/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.CDOViewEvent;
import org.eclipse.emf.cdo.CDOViewResourcesEvent;
import org.eclipse.emf.cdo.analyzer.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.common.CDOProtocolView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.EresourceFactory;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDOInvalidationNotificationImpl;
import org.eclipse.emf.internal.cdo.CDOMetaImpl;
import org.eclipse.emf.internal.cdo.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.CDOStore;
import org.eclipse.emf.internal.cdo.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.ResourceIDRequest;
import org.eclipse.emf.internal.cdo.protocol.ResourcePathRequest;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.internal.cdo.util.ModelUtil;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ref.ReferenceValueMap;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOViewImpl
extends org.eclipse.net4j.util.event.Notifier
implements CDOView,
CDOIDProvider,
Adapter.Internal {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_VIEW, CDOViewImpl.class);
    private int viewID;
    private CDOSessionImpl session;
    private ResourceSet resourceSet;
    private boolean uniqueResourceContents = true;
    private boolean invalidationNotificationsEnabled;
    private int loadRevisionCollectionChunkSize;
    private CDOFeatureAnalyzer featureAnalyzer = CDOFeatureAnalyzer.NOOP;
    private ConcurrentMap<CDOID, InternalCDOObject> objects;
    private CDOStore store = new CDOStore(this);
    private CDOID lastLookupID;
    private InternalCDOObject lastLookupObject;

    public CDOViewImpl(int id, CDOSessionImpl session) {
        this.viewID = id;
        this.session = session;
        this.invalidationNotificationsEnabled = (Boolean)OM.PREF_ENABLE_INVALIDATION_NOTIFICATIONS.getValue();
        this.loadRevisionCollectionChunkSize = (Integer)OM.PREF_LOAD_REVISION_COLLECTION_CHUNK_SIZE.getValue();
        this.objects = this.createObjectsMap();
    }

    protected ConcurrentMap<CDOID, InternalCDOObject> createObjectsMap() {
        return new ReferenceValueMap.Weak();
    }

    public int getViewID() {
        return this.viewID;
    }

    public CDOProtocolView.Type getViewType() {
        return CDOProtocolView.Type.READONLY;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public CDOSessionImpl getSession() {
        return this.session;
    }

    public CDOStore getStore() {
        return this.store;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean hasConflict() {
        return false;
    }

    @Override
    public boolean hasUniqueResourceContents() {
        return this.uniqueResourceContents;
    }

    @Override
    public void setUniqueResourceContents(boolean uniqueResourceContents) {
        this.uniqueResourceContents = uniqueResourceContents;
    }

    @Override
    public boolean isInvalidationNotificationsEnabled() {
        return this.invalidationNotificationsEnabled;
    }

    @Override
    public void setInvalidationNotificationsEnabled(boolean invalidationNotificationsEnabled) {
        this.invalidationNotificationsEnabled = invalidationNotificationsEnabled;
    }

    @Override
    public int getLoadRevisionCollectionChunkSize() {
        return this.loadRevisionCollectionChunkSize;
    }

    @Override
    public void setLoadRevisionCollectionChunkSize(int loadRevisionCollectionChunkSize) {
        this.loadRevisionCollectionChunkSize = loadRevisionCollectionChunkSize;
    }

    public CDOFeatureAnalyzer getFeatureAnalyzer() {
        return this.featureAnalyzer;
    }

    public void setFeatureAnalyzer(CDOFeatureAnalyzer featureAnalyzer) {
        this.featureAnalyzer = featureAnalyzer == null ? CDOFeatureAnalyzer.NOOP : featureAnalyzer;
    }

    public CDOTransactionImpl toTransaction() {
        if (this instanceof CDOTransactionImpl) {
            return (CDOTransactionImpl)this;
        }
        throw new ReadOnlyException("CDO view is read only: " + this);
    }

    @Override
    public boolean hasResource(String path) {
        CDOID id = this.getResourceID(path);
        return id != null && !id.isNull();
    }

    public CDOID getResourceID(String path) {
        try {
            IFailOverStrategy failOverStrategy = this.session.getFailOverStrategy();
            ResourceIDRequest request = new ResourceIDRequest(this.session.getChannel(), path);
            return (CDOID)failOverStrategy.send((RequestWithConfirmation)request);
        }
        catch (Exception ex) {
            throw new TransactionException((Throwable)ex);
        }
    }

    @Override
    public CDOResource getResource(String path) {
        URI uri = CDOUtil.createResourceURI(path);
        return (CDOResource)this.getResourceSet().getResource(uri, true);
    }

    public CDOResourceImpl getResource(CDOID resourceID) {
        if (resourceID == null || resourceID.isNull()) {
            throw new IllegalArgumentException("resourceID == null || resourceID == CDOID.NULL");
        }
        ResourceSet resourceSet = this.getResourceSet();
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            CDOResourceImpl cdoResource;
            if (!(resource instanceof CDOResourceImpl) || !resourceID.equals((cdoResource = (CDOResourceImpl)resource).cdoID())) continue;
            return cdoResource;
        }
        try {
            IFailOverStrategy failOverStrategy = this.session.getFailOverStrategy();
            ResourcePathRequest request = new ResourcePathRequest(this.session.getChannel(), resourceID);
            String path = (String)failOverStrategy.send((RequestWithConfirmation)request);
            return this.addResource(resourceID, path);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    public CDOResourceImpl addResource(CDOID id, String path) {
        CDOResourceImpl resource = (CDOResourceImpl)EresourceFactory.eINSTANCE.createCDOResource();
        resource.setPath(path);
        CDOResourceImpl resourceObject = resource;
        resourceObject.cdoInternalSetID(id);
        resourceObject.cdoInternalSetView(this);
        resourceObject.cdoInternalSetResource(resource);
        resourceObject.cdoInternalSetState(CDOState.PROXY);
        ResourceSet resourceSet = this.getResourceSet();
        resourceSet.getResources().add((Object)resource);
        return resource;
    }

    public InternalCDOObject newInstance(EClass eClass) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        return FSMUtil.adapt(eObject, this);
    }

    public InternalCDOObject newInstance(CDOClass cdoClass) {
        EClass eClass = ModelUtil.getEClass(cdoClass, this.session.getPackageRegistry());
        if (eClass == null) {
            throw new IllegalStateException("No EClass for " + cdoClass);
        }
        return this.newInstance(eClass);
    }

    public InternalCDORevision getRevision(CDOID id, boolean loadOnDemand) {
        CDORevisionManagerImpl revisionManager = this.session.getRevisionManager();
        return (InternalCDORevision)revisionManager.getRevision(id, this.session.getReferenceChunkSize(), loadOnDemand);
    }

    @Override
    public InternalCDOObject getObject(CDOID id) {
        return this.getObject(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOObject getObject(CDOID id, boolean loadOnDemand) {
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            if (id.equals(this.lastLookupID)) {
                return this.lastLookupObject;
            }
            this.lastLookupID = id;
            this.lastLookupObject = (InternalCDOObject)this.objects.get(id);
            if (this.lastLookupObject == null) {
                this.lastLookupObject = id.isMeta() ? this.createMetaObject((CDOIDMeta)id) : (loadOnDemand ? this.createObject(id) : this.createProxy(id));
                this.registerObject(this.lastLookupObject);
            }
            return this.lastLookupObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isObjectRegistered(CDOID id) {
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            return this.objects.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCDOObject removeObject(CDOID id) {
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            if (id.equals(this.lastLookupID)) {
                this.lastLookupID = null;
                this.lastLookupObject = null;
            }
            return (InternalCDOObject)this.objects.remove(id);
        }
    }

    private InternalCDOObject createMetaObject(CDOIDMeta id) {
        InternalEObject metaInstance;
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating meta object for " + id);
        }
        if ((metaInstance = this.session.lookupMetaInstance((CDOID)id)) == null) {
            throw new ImplementationError("No metaInstance for " + id);
        }
        return new CDOMetaImpl(this, metaInstance, (CDOID)id);
    }

    private InternalCDOObject createObject(CDOID id) {
        InternalCDORevision revision;
        CDOClass cdoClass;
        InternalCDOObject object;
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating object for " + id);
        }
        if ((object = this.newInstance(cdoClass = (revision = this.getRevision(id, true)).getCDOClass())) instanceof CDOResourceImpl) {
            object.cdoInternalSetResource((CDOResourceImpl)object);
        } else {
            CDOID resourceID = revision.getResourceID();
            if (!resourceID.isNull()) {
                CDOResourceImpl resource = this.getResource(resourceID);
                object.cdoInternalSetResource(resource);
            }
        }
        object.cdoInternalSetView(this);
        object.cdoInternalSetRevision((CDORevision)revision);
        object.cdoInternalSetID(revision.getID());
        object.cdoInternalSetState(CDOState.CLEAN);
        object.cdoInternalPostLoad();
        return object;
    }

    private InternalCDOObject createProxy(CDOID id) {
        CDOClass cdoClass;
        InternalCDOObject object;
        if (TRACER.isEnabled()) {
            TRACER.format("Creating proxy for " + id, new Object[0]);
        }
        if ((object = this.newInstance(cdoClass = this.getObjectType(id))) instanceof CDOResourceImpl) {
            object.cdoInternalSetResource((CDOResourceImpl)object);
        }
        object.cdoInternalSetView(this);
        object.cdoInternalSetID(id);
        object.cdoInternalSetState(CDOState.PROXY);
        return object;
    }

    private CDOClass getObjectType(CDOID id) {
        CDOClass type = this.session.getObjectType(id);
        if (type != null) {
            return type;
        }
        if (id.isLegacy()) {
            CDOClassRef typeRef = ((CDOIDObject)id).getClassRef();
            type = typeRef.resolve((CDOPackageManager)this.session.getPackageManager());
            this.session.registerObjectType(id, type);
            return type;
        }
        return this.session.requestObjectType(id);
    }

    public CDOID provideCDOID(Object idOrObject) {
        Object shouldBeCDOID = this.convertObjectToID(idOrObject);
        if (shouldBeCDOID instanceof CDOID) {
            CDOID id = (CDOID)shouldBeCDOID;
            if (TRACER.isEnabled() && id != idOrObject) {
                TRACER.format("Converted dangling reference: {0} --> {1}", new Object[]{idOrObject, id});
            }
            return id;
        }
        throw new IllegalStateException("Unable to provideCDOID: " + idOrObject.getClass().getName());
    }

    public Object convertObjectToID(Object potentialObject) {
        InternalCDOObject object;
        InternalEObject eObject;
        InternalCDOObject adapter;
        if (potentialObject instanceof CDOID) {
            return potentialObject;
        }
        if (potentialObject instanceof InternalEObject && !(potentialObject instanceof InternalCDOObject) && (adapter = FSMUtil.adapt(eObject = (InternalEObject)potentialObject, this)) != null) {
            potentialObject = adapter;
        }
        if (potentialObject instanceof InternalCDOObject && (object = (InternalCDOObject)potentialObject).cdoView() == this) {
            return object.cdoID();
        }
        return potentialObject;
    }

    public Object convertIDToObject(Object potentialID) {
        if (potentialID instanceof CDOID) {
            if (potentialID == CDOID.NULL) {
                return null;
            }
            CDOID id = (CDOID)potentialID;
            InternalCDOObject result = this.getObject(id, true);
            if (result == null) {
                throw new ImplementationError("ID not registered: " + id);
            }
            return result.cdoInternalInstance();
        }
        return potentialID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(InternalCDOObject object) {
        InternalCDOObject old;
        if (TRACER.isEnabled()) {
            TRACER.format("Registering {0}", new Object[]{object});
        }
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            old = this.objects.put(object.cdoID(), object);
        }
        if (old != null) {
            throw new IllegalStateException("Duplicate ID: " + object);
        }
    }

    public void deregisterObject(InternalCDOObject object) {
        InternalCDOObject old;
        if (TRACER.isEnabled()) {
            TRACER.format("Deregistering {0}", new Object[]{object});
        }
        if ((old = this.removeObject(object.cdoID())) == null) {
            throw new IllegalStateException("Unknown ID: " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remapObject(CDOID oldID) {
        CDOID newID;
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            InternalCDOObject object = (InternalCDOObject)this.objects.remove(oldID);
            newID = object.cdoID();
            this.objects.put(newID, object);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Remapping {0} --> {1}", new Object[]{oldID, newID});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInvalidation(long timeStamp, Set<CDOIDAndVersion> dirtyOIDs) {
        ArrayList<InternalCDOObject> dirtyObjects = this.invalidationNotificationsEnabled ? new ArrayList<InternalCDOObject>() : null;
        for (CDOIDAndVersion dirtyOID : dirtyOIDs) {
            InternalCDOObject dirtyObject;
            ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
            synchronized (concurrentMap) {
                dirtyObject = (InternalCDOObject)this.objects.get(dirtyOID.getID());
                if (dirtyObject != null) {
                    CDOStateMachine.INSTANCE.invalidate(dirtyObject, timeStamp);
                }
            }
            if (dirtyObject == null || dirtyObjects == null || !dirtyObject.eNotificationRequired()) continue;
            dirtyObjects.add(dirtyObject);
        }
        if (dirtyObjects != null) {
            for (InternalCDOObject dirtyObject : dirtyObjects) {
                CDOInvalidationNotificationImpl notification = new CDOInvalidationNotificationImpl(dirtyObject);
                dirtyObject.eNotify(notification);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int reload(CDOObject ... objects) {
        block6: {
            if (objects == null || objects.length == 0) break block6;
            internalObjects = new ArrayList<E>(objects.length);
            var6_3 = objects;
            var5_4 = objects.length;
            var4_5 = 0;
            if (true) ** GOTO lbl22
        }
        object /* !! */  = objects;
        synchronized (objects) {
            internalObjects = new ArrayList<V>(this.objects.values());
            // ** MonitorExit[object /* !! */ ] (shouldn't be in output)
        }
        do {
            if ((object /* !! */  = var6_3[var4_5]) instanceof InternalCDOObject) {
                internalObjects.add((InternalCDOObject)object /* !! */ );
            }
            ++var4_5;
lbl22:
            // 2 sources

        } while (var4_5 < var5_4);
        {
            result = internalObjects.size();
            if (result != 0) {
                CDOStateMachine.INSTANCE.reload(internalObjects.toArray(new InternalCDOObject[result]));
            }
            return result;
        }
    }

    @Override
    public void close() {
        this.session.viewDetached(this);
    }

    public String toString() {
        return MessageFormat.format("CDOView({0})", this.viewID);
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof ResourceSet;
    }

    public Notifier getTarget() {
        return this.resourceSet;
    }

    public void setTarget(Notifier newTarget) {
        ResourceSet resourceSet = (ResourceSet)newTarget;
        if (TRACER.isEnabled()) {
            TRACER.trace("Attaching CDO view to " + resourceSet);
        }
        this.resourceSet = resourceSet;
        for (Resource resource : resourceSet.getResources()) {
            if (!(resource instanceof CDOResourceImpl)) continue;
            CDOResourceImpl cdoResource = (CDOResourceImpl)resource;
            this.notifyAdd(cdoResource);
        }
    }

    public void unsetTarget(Notifier oldTarget) {
        ResourceSet resourceSet = (ResourceSet)oldTarget;
        for (Resource resource : resourceSet.getResources()) {
            if (!(resource instanceof CDOResourceImpl)) continue;
            CDOResourceImpl cdoResource = (CDOResourceImpl)resource;
            this.notifyRemove(cdoResource);
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Detaching CDO view from " + resourceSet);
        }
        if (resourceSet == oldTarget) {
            this.setTarget(null);
        }
    }

    public void notifyChanged(Notification msg) {
        try {
            switch (msg.getEventType()) {
                case 3: {
                    this.notifyAdd(msg);
                    break;
                }
                case 5: {
                    this.notifyAddMany(msg);
                    break;
                }
                case 4: {
                    this.notifyRemove(msg);
                    break;
                }
                case 6: {
                    this.notifyRemoveMany(msg);
                }
            }
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    private void notifyAdd(Notification msg) {
        if (msg.getNewValue() instanceof CDOResourceImpl) {
            this.notifyAdd((CDOResourceImpl)msg.getNewValue());
        }
    }

    private void notifyAddMany(Notification msg) {
        EList newResources = (EList)msg.getNewValue();
        EList oldResources = (EList)msg.getOldValue();
        for (Resource newResource : newResources) {
            if (!(newResource instanceof CDOResourceImpl) || oldResources.contains((Object)newResource)) continue;
            this.notifyAdd((CDOResourceImpl)newResource);
        }
    }

    private void notifyAdd(CDOResourceImpl cdoResource) {
        try {
            CDOStateMachine.INSTANCE.attach(cdoResource, cdoResource, this);
            this.fireEvent(new ResourcesEvent(cdoResource.getPath(), CDOViewResourcesEvent.Kind.ADDED));
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            try {
                cdoResource.cdoInternalSetState(CDOState.NEW);
                this.resourceSet.getResources().remove((Object)cdoResource);
            }
            catch (RuntimeException runtimeException) {}
            throw ex;
        }
    }

    private void notifyRemove(Notification msg) {
        if (msg.getOldValue() instanceof CDOResourceImpl) {
            this.notifyRemove((CDOResourceImpl)msg.getOldValue());
        }
    }

    private void notifyRemoveMany(Notification msg) {
        EList newResources = (EList)msg.getNewValue();
        EList oldResources = (EList)msg.getOldValue();
        for (Resource oldResource : oldResources) {
            if (!(oldResource instanceof CDOResourceImpl) || newResources.contains((Object)oldResource)) continue;
            this.notifyRemove((CDOResourceImpl)oldResource);
        }
    }

    private void notifyRemove(CDOResourceImpl cdoResource) {
        CDOStateMachine.INSTANCE.detach(cdoResource);
        this.fireEvent(new ResourcesEvent(cdoResource.getPath(), CDOViewResourcesEvent.Kind.REMOVED));
    }

    protected abstract class Event
    extends org.eclipse.net4j.util.event.Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;

        public Event() {
            super((INotifier)CDOViewImpl.this);
        }

        public CDOViewImpl getView() {
            return CDOViewImpl.this;
        }
    }

    private final class ResourcesEvent
    extends Event
    implements CDOViewResourcesEvent {
        private static final long serialVersionUID = 1L;
        private String resourcePath;
        private CDOViewResourcesEvent.Kind kind;

        public ResourcesEvent(String resourcePath, CDOViewResourcesEvent.Kind kind) {
            this.resourcePath = resourcePath;
            this.kind = kind;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public CDOViewResourcesEvent.Kind getKind() {
            return this.kind;
        }

        public String toString() {
            return MessageFormat.format("CDOViewResourcesEvent[source={0}, {1}={2}]", new Object[]{this.getSource(), this.resourcePath, this.kind});
        }
    }
}

