/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOReferenceProxy;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.CDOSessionPackageManagerImpl;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.CDOViewImpl;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.internal.cdo.util.GenUtil;
import org.eclipse.emf.internal.cdo.util.ModelUtil;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOStore
implements InternalEObject.EStore {
    private final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOStore.class);
    private CDOViewImpl view;

    public CDOStore(CDOViewImpl view) {
        this.view = view;
    }

    public CDOViewImpl getView() {
        return this.view;
    }

    public void setContainer(InternalEObject eObject, CDOResource newResource, InternalEObject newContainer, int newContainerFeatureID) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("setContainer({0}, {1}, {2}, {3})", new Object[]{cdoObject, newResource, newContainer, newContainerFeatureID});
        }
        CDOViewImpl newView = (CDOViewImpl)cdoObject.cdoView();
        CDOID containerID = (CDOID)newView.convertObjectToID(newContainer);
        CDOID resourceID = newResource == null ? null : newResource.cdoID();
        CDOContainerFeatureDeltaImpl delta = new CDOContainerFeatureDeltaImpl(containerID, newContainerFeatureID);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        revision.setResourceID(resourceID);
        revision.setContainerID(containerID);
        revision.setContainingFeatureID(newContainerFeatureID);
    }

    public InternalEObject getContainer(InternalEObject eObject) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("getContainer({0})", new Object[]{cdoObject});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        CDOID id = revision.getContainerID();
        return (InternalEObject)((CDOViewImpl)cdoObject.cdoView()).convertIDToObject(id);
    }

    public int getContainingFeatureID(InternalEObject eObject) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("getContainingFeatureID({0})", new Object[]{cdoObject});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.getContainingFeatureID();
    }

    @Deprecated
    public EStructuralFeature getContainingFeature(InternalEObject eObject) {
        throw new UnsupportedOperationException("Use getContainingFeatureID() instead");
    }

    public Object get(InternalEObject eObject, EStructuralFeature eFeature, int index) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("get({0}, {1}, {2})", new Object[]{cdoObject, cdoFeature, index});
        }
        this.view.getFeatureAnalyzer().preTraverseFeature(cdoObject, cdoFeature, index);
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        Object value = this.get(revision, cdoFeature, index);
        if (cdoFeature.isReference()) {
            if (cdoFeature.isMany() && value instanceof CDOID) {
                CDOID id = (CDOID)value;
                this.loadAhead(revision, cdoFeature, id, index);
            }
            value = this.view.convertIDToObject(value);
        } else if (cdoFeature.getType() == CDOType.CUSTOM) {
            value = EcoreUtil.createFromString((EDataType)((EDataType)eFeature.getEType()), (String)((String)value));
        }
        this.view.getFeatureAnalyzer().postTraverseFeature(cdoObject, cdoFeature, index, value);
        return value;
    }

    private void loadAhead(InternalCDORevision revision, CDOFeature cdoFeature, CDOID id, int index) {
        CDOSessionImpl session = this.view.getSession();
        CDORevisionManagerImpl revisionManager = session.getRevisionManager();
        int chunkSize = this.view.getLoadRevisionCollectionChunkSize();
        if (chunkSize > 1 && !revisionManager.containsRevision(id)) {
            MoveableList list = revision.getList(cdoFeature);
            int fromIndex = index;
            int toIndex = Math.min(index + chunkSize, list.size()) - 1;
            HashSet<CDOID> notRegistered = new HashSet<CDOID>();
            int i = fromIndex;
            while (i <= toIndex) {
                CDOID idElement;
                Object element = list.get(i);
                if (element instanceof CDOID && !(idElement = (CDOID)element).isTemporary() && !revisionManager.containsRevision(idElement) && !notRegistered.contains(idElement)) {
                    notRegistered.add(idElement);
                }
                ++i;
            }
            if (!notRegistered.isEmpty()) {
                int referenceChunk = session.getReferenceChunkSize();
                revisionManager.getRevisions(notRegistered, referenceChunk);
            }
        }
    }

    private Object get(InternalCDORevision revision, CDOFeature cdoFeature, int index) {
        Object result = revision.get(cdoFeature, index);
        if (cdoFeature.isReference() && result instanceof CDOReferenceProxy) {
            result = ((CDOReferenceProxy)result).resolve();
        }
        return result;
    }

    public boolean isSet(InternalEObject eObject, EStructuralFeature eFeature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("isSet({0}, {1})", new Object[]{cdoObject, cdoFeature});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.isSet(cdoFeature);
    }

    public int size(InternalEObject eObject, EStructuralFeature eFeature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("size({0}, {1})", new Object[]{cdoObject, cdoFeature});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.size(cdoFeature);
    }

    public boolean isEmpty(InternalEObject eObject, EStructuralFeature eFeature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("isEmpty({0}, {1})", new Object[]{cdoObject, cdoFeature});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.isEmpty(cdoFeature);
    }

    public boolean contains(InternalEObject eObject, EStructuralFeature eFeature, Object value) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("contains({0}, {1}, {2})", new Object[]{cdoObject, cdoFeature, value});
        }
        if (cdoFeature.isReference()) {
            value = ((CDOViewImpl)cdoObject.cdoView()).convertObjectToID(value);
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.contains(cdoFeature, value);
    }

    public int indexOf(InternalEObject eObject, EStructuralFeature eFeature, Object value) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("indexOf({0}, {1}, {2})", new Object[]{cdoObject, cdoFeature, value});
        }
        if (cdoFeature.isReference()) {
            value = ((CDOViewImpl)cdoObject.cdoView()).convertObjectToID(value);
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.indexOf(cdoFeature, value);
    }

    public int lastIndexOf(InternalEObject eObject, EStructuralFeature eFeature, Object value) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("lastIndexOf({0}, {1}, {2})", new Object[]{cdoObject, cdoFeature, value});
        }
        if (cdoFeature.isReference()) {
            value = ((CDOViewImpl)cdoObject.cdoView()).convertObjectToID(value);
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.lastIndexOf(cdoFeature, value);
    }

    public int hashCode(InternalEObject eObject, EStructuralFeature eFeature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("hashCode({0}, {1})", new Object[]{cdoObject, cdoFeature});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.hashCode(cdoFeature);
    }

    public Object[] toArray(InternalEObject eObject, EStructuralFeature eFeature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("toArray({0}, {1})", new Object[]{cdoObject, cdoFeature});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        Object[] result = revision.toArray(cdoFeature);
        if (cdoFeature.isReference()) {
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof CDOReferenceProxy) {
                    result[i] = ((CDOReferenceProxy)result[i]).resolve();
                }
                result[i] = ((CDOViewImpl)cdoObject.cdoView()).convertIDToObject(result[i]);
                ++i;
            }
        }
        return result;
    }

    public <T> T[] toArray(InternalEObject eObject, EStructuralFeature eFeature, T[] a) {
        Object[] array = this.toArray(eObject, eFeature);
        int size = array.length;
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        System.arraycopy(array, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public Object set(InternalEObject eObject, EStructuralFeature eFeature, int index, Object value) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("set({0}, {1}, {2}, {3})", new Object[]{cdoObject, cdoFeature, index, value});
        }
        if (cdoFeature.getType() == CDOType.CUSTOM) {
            value = EcoreUtil.convertToString((EDataType)((EDataType)eFeature.getEType()), (Object)value);
        } else if (value == null && GenUtil.isPrimitiveType(eFeature.getEType())) {
            value = eFeature.getDefaultValue();
        }
        CDOSetFeatureDeltaImpl delta = new CDOSetFeatureDeltaImpl(cdoFeature, index, value);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        if (cdoFeature.isReference()) {
            Object oldValue = revision.get(cdoFeature, index);
            if (oldValue instanceof CDOReferenceProxy) {
                ((CDOReferenceProxy)oldValue).resolve();
            }
            if (cdoFeature.isContainment() && value != null) {
                this.handleContainmentAdd(cdoObject, value);
            }
        }
        Object result = revision.set(cdoFeature, index, value);
        if (cdoFeature.isReference()) {
            result = ((CDOViewImpl)cdoObject.cdoView()).convertIDToObject(result);
            if (cdoFeature.isContainment() && result != null) {
                this.handleContainmentRemove(cdoObject, value);
            }
        }
        return result;
    }

    public void unset(InternalEObject eObject, EStructuralFeature eFeature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("unset({0}, {1})", new Object[]{cdoObject, cdoFeature});
        }
        CDOUnsetFeatureDeltaImpl delta = new CDOUnsetFeatureDeltaImpl(cdoFeature);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        revision.unset(cdoFeature);
    }

    public void add(InternalEObject eObject, EStructuralFeature eFeature, int index, Object value) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("add({0}, {1}, {2}, {3})", new Object[]{cdoObject, cdoFeature, index, value});
        }
        if (cdoFeature.isReference()) {
            if (cdoFeature.isContainment() && value != null) {
                this.handleContainmentAdd(cdoObject, value);
            }
            value = ((CDOViewImpl)cdoObject.cdoView()).convertObjectToID(value);
        }
        CDOAddFeatureDeltaImpl delta = new CDOAddFeatureDeltaImpl(cdoFeature, index, value);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        revision.add(cdoFeature, index, value);
    }

    public Object remove(InternalEObject eObject, EStructuralFeature eFeature, int index) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("remove({0}, {1}, {2})", new Object[]{cdoObject, cdoFeature, index});
        }
        CDORemoveFeatureDeltaImpl delta = new CDORemoveFeatureDeltaImpl(cdoFeature, index);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        Object result = revision.remove(cdoFeature, index);
        if (cdoFeature.isReference()) {
            if (result instanceof CDOReferenceProxy) {
                result = ((CDOReferenceProxy)result).resolve();
            }
            result = ((CDOViewImpl)cdoObject.cdoView()).convertIDToObject(result);
            if (cdoFeature.isContainment() && result != null) {
                this.handleContainmentRemove(cdoObject, result);
            }
        }
        return result;
    }

    public void clear(InternalEObject eObject, EStructuralFeature eFeature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("clear({0}, {1})", new Object[]{cdoObject, cdoFeature});
        }
        CDOClearFeatureDeltaImpl delta = new CDOClearFeatureDeltaImpl(cdoFeature);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        revision.clear(cdoFeature);
    }

    public Object move(InternalEObject eObject, EStructuralFeature eFeature, int target, int source) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        CDOFeature cdoFeature = this.getCDOFeature(cdoObject, eFeature);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("move({0}, {1}, {2}, {3})", new Object[]{cdoObject, cdoFeature, target, source});
        }
        CDOMoveFeatureDeltaImpl delta = new CDOMoveFeatureDeltaImpl(cdoFeature, target, source);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        Object result = revision.move(cdoFeature, target, source);
        if (cdoFeature.isReference()) {
            if (result instanceof CDOReferenceProxy) {
                result = ((CDOReferenceProxy)result).resolve();
            }
            result = ((CDOViewImpl)cdoObject.cdoView()).convertIDToObject(result);
        }
        return result;
    }

    public EObject create(EClass eClass) {
        throw new UnsupportedOperationException("Use the generated factory to create objects");
    }

    public String toString() {
        return MessageFormat.format("CDOStore[{0}]", this.view);
    }

    private InternalCDOObject getCDOObject(Object object) {
        return FSMUtil.adapt(object, this.view);
    }

    private CDOFeature getCDOFeature(InternalCDOObject cdoObject, EStructuralFeature eFeature) {
        CDOViewImpl view = (CDOViewImpl)cdoObject.cdoView();
        if (view == null) {
            throw new IllegalStateException("view == null");
        }
        CDOSessionPackageManagerImpl packageManager = view.getSession().getPackageManager();
        return ModelUtil.getCDOFeature(eFeature, packageManager);
    }

    private static InternalCDORevision getRevisionForReading(InternalCDOObject cdoObject) {
        CDOStateMachine.INSTANCE.read(cdoObject);
        return CDOStore.getRevision(cdoObject);
    }

    private static InternalCDORevision getRevisionForWriting(InternalCDOObject cdoObject, CDOFeatureDelta delta) {
        CDOStateMachine.INSTANCE.write(cdoObject, delta);
        return CDOStore.getRevision(cdoObject);
    }

    private static InternalCDORevision getRevision(InternalCDOObject cdoObject) {
        InternalCDORevision revision = (InternalCDORevision)cdoObject.cdoRevision();
        if (revision == null) {
            throw new IllegalStateException("revision == null");
        }
        return revision;
    }

    private void handleContainmentAdd(InternalCDOObject container, Object value) {
        CDOViewImpl containerView = (CDOViewImpl)container.cdoView();
        InternalCDOObject contained = this.getCDOObject(value);
        FSMUtil.checkLegacySystemAvailability(containerView.getSession(), contained);
        CDOViewImpl containedView = (CDOViewImpl)contained.cdoView();
        if (containedView != containerView) {
            if (containedView != null) {
                CDOStateMachine.INSTANCE.detach(contained);
            }
            CDOStateMachine.INSTANCE.attach(contained, container.cdoResource(), containerView);
        }
    }

    private void handleContainmentRemove(InternalCDOObject container, Object value) {
    }
}

