/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ServerException;
import org.eclipse.emf.internal.cdo.CDOEvent;
import org.eclipse.emf.internal.cdo.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.CDOViewImpl;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.CommitTransactionResult;
import org.eclipse.emf.internal.cdo.protocol.ResourceIDRequest;
import org.eclipse.emf.internal.cdo.protocol.VerifyRevisionRequest;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.util.fsm.FiniteStateMachine;
import org.eclipse.net4j.util.fsm.ITransition;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOStateMachine
extends FiniteStateMachine<CDOState, CDOEvent, InternalCDOObject> {
    public static final CDOStateMachine INSTANCE = new CDOStateMachine();
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOStateMachine.class);
    private InternalCDOObject lastTracedObject;
    private CDOState lastTracedState;
    private CDOEvent lastTracedEvent;

    private CDOStateMachine() {
        super(CDOState.class, CDOEvent.class);
        this.init(CDOState.TRANSIENT, CDOEvent.PREPARE, new PrepareTransition());
        this.init(CDOState.TRANSIENT, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.TRANSIENT, CDOEvent.DETACH, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.READ, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.WRITE, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.INVALIDATE, FAIL);
        this.init(CDOState.TRANSIENT, CDOEvent.RELOAD, IGNORE);
        this.init(CDOState.TRANSIENT, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.TRANSIENT, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.ATTACH, new AttachTransition());
        this.init(CDOState.PREPARED, CDOEvent.DETACH, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.READ, IGNORE);
        this.init(CDOState.PREPARED, CDOEvent.WRITE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.INVALIDATE, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.RELOAD, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.PREPARED, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.NEW, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.NEW, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.NEW, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.NEW, CDOEvent.READ, IGNORE);
        this.init(CDOState.NEW, CDOEvent.WRITE, IGNORE);
        this.init(CDOState.NEW, CDOEvent.INVALIDATE, FAIL);
        this.init(CDOState.NEW, CDOEvent.RELOAD, FAIL);
        this.init(CDOState.NEW, CDOEvent.COMMIT, new CommitTransition());
        this.init(CDOState.NEW, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.CLEAN, CDOEvent.READ, IGNORE);
        this.init(CDOState.CLEAN, CDOEvent.WRITE, new WriteTransition());
        this.init(CDOState.CLEAN, CDOEvent.INVALIDATE, new InvalidateTransition(null, null));
        this.init(CDOState.CLEAN, CDOEvent.RELOAD, new ReloadTransition());
        this.init(CDOState.CLEAN, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.CLEAN, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.ATTACH, FAIL);
        this.init(CDOState.DIRTY, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.DIRTY, CDOEvent.READ, IGNORE);
        this.init(CDOState.DIRTY, CDOEvent.WRITE, new RewriteTransition());
        this.init(CDOState.DIRTY, CDOEvent.INVALIDATE, new ConflictTransition());
        this.init(CDOState.DIRTY, CDOEvent.RELOAD, new ReloadTransition());
        this.init(CDOState.DIRTY, CDOEvent.COMMIT, new CommitTransition());
        this.init(CDOState.DIRTY, CDOEvent.ROLLBACK, new RollbackTransition());
        this.init(CDOState.PROXY, CDOEvent.PREPARE, new LoadResourceTransition());
        this.init(CDOState.PROXY, CDOEvent.ATTACH, IGNORE);
        this.init(CDOState.PROXY, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.PROXY, CDOEvent.READ, new LoadTransition(false));
        this.init(CDOState.PROXY, CDOEvent.WRITE, new LoadTransition(true));
        this.init(CDOState.PROXY, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.PROXY, CDOEvent.RELOAD, new ReloadTransition());
        this.init(CDOState.PROXY, CDOEvent.COMMIT, FAIL);
        this.init(CDOState.PROXY, CDOEvent.ROLLBACK, FAIL);
        this.init(CDOState.CONFLICT, CDOEvent.PREPARE, FAIL);
        this.init(CDOState.CONFLICT, CDOEvent.ATTACH, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.DETACH, new DetachTransition());
        this.init(CDOState.CONFLICT, CDOEvent.READ, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.WRITE, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.INVALIDATE, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.RELOAD, FAIL);
        this.init(CDOState.CONFLICT, CDOEvent.COMMIT, IGNORE);
        this.init(CDOState.CONFLICT, CDOEvent.ROLLBACK, new RollbackTransition());
    }

    public void attach(InternalCDOObject object, CDOResource resource, CDOViewImpl view) {
        ResourceAndView data = new ResourceAndView();
        data.resource = resource;
        data.view = view;
        if (TRACER.isEnabled()) {
            TRACER.format("PREPARE: {0} --> {1}", new Object[]{object, view});
        }
        this.process(object, CDOEvent.PREPARE, data);
        if (TRACER.isEnabled()) {
            TRACER.format("ATTACH: {0} --> {1}", new Object[]{object, view});
        }
        this.process(object, CDOEvent.ATTACH, null);
    }

    public void detach(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            this.trace(object, CDOEvent.DETACH);
        }
        this.process(object, CDOEvent.DETACH, null);
    }

    public void read(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            this.trace(object, CDOEvent.READ);
        }
        this.process(object, CDOEvent.READ, null);
    }

    public void write(InternalCDOObject object) {
        this.write(object, null);
    }

    public void write(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        if (TRACER.isEnabled()) {
            this.trace(object, CDOEvent.WRITE);
        }
        this.process(object, CDOEvent.WRITE, featureDelta);
    }

    public void reload(InternalCDOObject ... objects) {
        CDOView view = null;
        HashMap<CDOID, InternalCDOObject> ids = new HashMap<CDOID, InternalCDOObject>();
        List<Object> revisions = new ArrayList<InternalCDORevision>();
        ArrayList<InternalCDORevision> revised = new ArrayList<InternalCDORevision>();
        InternalCDOObject[] internalCDOObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOObject internalCDOObject = internalCDOObjectArray[n2];
            CDOState state = internalCDOObject.cdoState();
            if (state != CDOState.TRANSIENT && state != CDOState.PREPARED && state != CDOState.NEW && state != CDOState.CONFLICT) {
                InternalCDORevision revision;
                if (view == null) {
                    view = internalCDOObject.cdoView();
                }
                if ((revision = (InternalCDORevision)internalCDOObject.cdoRevision()).isCurrent()) {
                    revisions.add(revision);
                } else {
                    revised.add(revision);
                }
                ids.put(internalCDOObject.cdoID(), internalCDOObject);
            }
            ++n2;
        }
        if (view != null) {
            try {
                CDOSession cDOSession = view.getSession();
                IChannel channel = cDOSession.getChannel();
                VerifyRevisionRequest request = new VerifyRevisionRequest(channel, revisions);
                revisions = (List)cDOSession.getFailOverStrategy().send((RequestWithConfirmation)request);
            }
            catch (Exception exception) {
                throw new TransportException((Throwable)exception);
            }
            revisions.addAll(revised);
            for (InternalCDORevision internalCDORevision : revisions) {
                InternalCDOObject object = (InternalCDOObject)ids.get(internalCDORevision.getID());
                if (TRACER.isEnabled()) {
                    this.trace(object, CDOEvent.RELOAD);
                }
                this.process(object, CDOEvent.RELOAD, null);
            }
        }
    }

    public void invalidate(InternalCDOObject object, long timeStamp) {
        if (TRACER.isEnabled()) {
            this.trace(object, CDOEvent.INVALIDATE);
        }
        this.process(object, CDOEvent.INVALIDATE, timeStamp);
    }

    public void commit(InternalCDOObject object, CommitTransactionResult result) {
        if (TRACER.isEnabled()) {
            this.trace(object, CDOEvent.COMMIT);
        }
        this.process(object, CDOEvent.COMMIT, result);
    }

    public void rollback(InternalCDOObject object, boolean remote) {
        if (TRACER.isEnabled()) {
            this.trace(object, CDOEvent.ROLLBACK);
        }
        this.process(object, CDOEvent.ROLLBACK, remote);
    }

    protected CDOState getState(InternalCDOObject object) {
        return object.cdoState();
    }

    protected void setState(InternalCDOObject object, CDOState state) {
        object.cdoInternalSetState(state);
    }

    private void trace(InternalCDOObject object, CDOEvent event) {
        CDOState state = object.cdoState();
        if (this.lastTracedObject != object || this.lastTracedState != state || this.lastTracedEvent != event) {
            TRACER.format("{0}: {1}", new Object[]{event, object.getClass().getName()});
            this.lastTracedObject = object;
            this.lastTracedState = state;
            this.lastTracedEvent = event;
        }
    }

    private void testAttach(InternalCDOObject object) {
        this.process(object, CDOEvent.ATTACH, null);
    }

    private void testReload(InternalCDOObject object) {
        this.process(object, CDOEvent.RELOAD, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AttachTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private AttachTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            CDOTransactionImpl transaction = (CDOTransactionImpl)object.cdoView();
            object.cdoInternalPostAttach();
            CDOStateMachine.this.changeState(object, CDOState.NEW);
            Iterator<InternalCDOObject> it = FSMUtil.iterator(object.eContents(), transaction);
            while (it.hasNext()) {
                InternalCDOObject content = it.next();
                INSTANCE.process(content, CDOEvent.ATTACH, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CommitTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, CommitTransactionResult> {
        private CommitTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, CommitTransactionResult data) {
            CDOID id;
            CDOViewImpl view = (CDOViewImpl)object.cdoView();
            Map<CDOIDTemp, CDOID> idMappings = data.getIDMappings();
            CDOID newID = idMappings.get(id = object.cdoID());
            if (newID != null) {
                object.cdoInternalSetID(newID);
                view.remapObject(id);
                id = newID;
            }
            InternalCDORevision revision = (InternalCDORevision)object.cdoRevision();
            revision.setID(id);
            revision.setUntransactional();
            revision.setCreated(data.getTimeStamp());
            revision.adjustReferences(idMappings);
            CDORevisionManagerImpl revisionManager = view.getSession().getRevisionManager();
            revisionManager.addRevision(revision);
            CDOStateMachine.this.changeState(object, CDOState.CLEAN);
        }
    }

    private final class ConflictTransition
    extends InvalidateTransition {
        private ConflictTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Long timeStamp) {
            this.reviseObject(object, timeStamp);
            CDOViewImpl view = (CDOViewImpl)object.cdoView();
            CDOTransactionImpl transaction = view.toTransaction();
            transaction.setConflict(object);
            CDOStateMachine.this.changeState(object, CDOState.CONFLICT);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DetachTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private DetachTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            CDOTransactionImpl transaction = (CDOTransactionImpl)object.cdoView();
            object.cdoInternalSetState(CDOState.TRANSIENT);
            Iterator<InternalCDOObject> it = FSMUtil.iterator(object.eContents(), transaction);
            while (it.hasNext()) {
                InternalCDOObject content = it.next();
                INSTANCE.process(content, CDOEvent.DETACH, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvalidateTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Long> {
        private InvalidateTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Long timeStamp) {
            this.reviseObject(object, timeStamp);
            CDOStateMachine.this.changeState(object, CDOState.PROXY);
        }

        protected void reviseObject(InternalCDOObject object, Long timeStamp) {
            InternalCDORevision revision = (InternalCDORevision)object.cdoRevision();
            revision.setRevised(timeStamp - 1L);
        }

        /* synthetic */ InvalidateTransition(InvalidateTransition invalidateTransition, InvalidateTransition invalidateTransition2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LoadResourceTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, ResourceAndView> {
        private LoadResourceTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, ResourceAndView data) {
            CDOID id = this.requestID(data.resource, data.view);
            if (id.isNull()) {
                throw new ServerException("Resource not available: " + data.resource.getPath());
            }
            object.cdoInternalSetID(id);
            object.cdoInternalSetResource(data.resource);
            object.cdoInternalSetView(data.view);
            data.view.registerObject(object);
        }

        private CDOID requestID(CDOResource resource, CDOViewImpl view) {
            try {
                String path = CDOUtil.extractResourcePath(resource.getURI());
                CDOSessionImpl session = view.getSession();
                IFailOverStrategy failOverStrategy = session.getFailOverStrategy();
                ResourceIDRequest request = new ResourceIDRequest(session.getChannel(), path);
                return (CDOID)failOverStrategy.send((RequestWithConfirmation)request);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new TransportException((Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LoadTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private boolean forWrite;

        public LoadTransition(boolean forWrite) {
            this.forWrite = forWrite;
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object delta) {
            CDOID id = object.cdoID();
            CDOViewImpl view = (CDOViewImpl)object.cdoView();
            InternalCDORevision revision = view.getRevision(id, true);
            object.cdoInternalSetRevision((CDORevision)revision);
            CDOStateMachine.this.changeState(object, CDOState.CLEAN);
            object.cdoInternalPostLoad();
            if (this.forWrite) {
                INSTANCE.write(object, (CDOFeatureDelta)delta);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PrepareTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, ResourceAndView> {
        private PrepareTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, ResourceAndView data) {
            CDOTransactionImpl transaction = data.view.toTransaction();
            CDORevisionManagerImpl revisionManager = transaction.getSession().getRevisionManager();
            CDOIDTemp id = transaction.getNextTemporaryID();
            object.cdoInternalSetID((CDOID)id);
            object.cdoInternalSetResource(data.resource);
            object.cdoInternalSetView(data.view);
            CDOStateMachine.this.changeState(object, CDOState.PREPARED);
            CDOClass cdoClass = object.cdoClass();
            InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.create((CDORevisionResolver)revisionManager, (CDOClass)cdoClass, (CDOID)id);
            revision.setVersion(-1);
            revision.setResourceID(data.resource.cdoID());
            object.cdoInternalSetRevision((CDORevision)revision);
            data.view.registerObject(object);
            transaction.registerNew(object);
            Iterator<InternalCDOObject> it = FSMUtil.iterator(object.eContents(), transaction);
            while (it.hasNext()) {
                InternalCDOObject content = it.next();
                INSTANCE.process(content, CDOEvent.PREPARE, data);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReloadTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private ReloadTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object NULL) {
            CDOStateMachine.this.changeState(object, CDOState.PROXY);
        }
    }

    private static final class ResourceAndView {
        public CDOResource resource;
        public CDOViewImpl view;

        private ResourceAndView() {
        }

        public String toString() {
            return MessageFormat.format("ResourceAndView({0}, {1})", this.resource, this.view);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RewriteTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private RewriteTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object featureDelta) {
            CDOViewImpl view = (CDOViewImpl)object.cdoView();
            CDOTransactionImpl transaction = view.toTransaction();
            transaction.registerFeatureDelta(object, (CDOFeatureDelta)featureDelta);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RollbackTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Boolean> {
        private RollbackTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Boolean remote) {
            CDOViewImpl view = (CDOViewImpl)object.cdoView();
            CDOID id = object.cdoID();
            CDORevision transactionalRevision = object.cdoRevision();
            int version = transactionalRevision.getVersion();
            CDORevisionManagerImpl revisionManager = view.getSession().getRevisionManager();
            InternalCDORevision previousRevision = revisionManager.getRevisionByVersion(id, 0, version - 1);
            object.cdoInternalSetRevision((CDORevision)previousRevision);
            CDOStateMachine.this.changeState(object, remote != false ? CDOState.PROXY : CDOState.CLEAN);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WriteTransition
    implements ITransition<CDOState, CDOEvent, InternalCDOObject, Object> {
        private WriteTransition() {
        }

        public void execute(InternalCDOObject object, CDOState state, CDOEvent event, Object featureDelta) {
            InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.copy((CDORevision)object.cdoRevision());
            revision.setTransactional();
            object.cdoInternalSetRevision((CDORevision)revision);
            CDOViewImpl view = (CDOViewImpl)object.cdoView();
            CDOTransactionImpl transaction = view.toTransaction();
            transaction.registerDirty(object, (CDOFeatureDelta)featureDelta);
            CDOStateMachine.this.changeState(object, CDOState.DIRTY);
        }
    }
}

