/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.CDOTransactionStartedEvent;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.internal.ui.ItemsProcessor;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOEventHandler {
    private CDOView view;
    private TreeViewer treeViewer;
    private IListener sessionListener = new IListener(){

        public void notifyEvent(IEvent event) {
            ILifecycleEvent e;
            if (event instanceof CDOSessionInvalidationEvent) {
                CDOSessionInvalidationEvent e2 = (CDOSessionInvalidationEvent)event;
                if (e2.getView() != CDOEventHandler.this.view) {
                    CDOEventHandler.this.sessionInvalidated(e2.getDirtyOIDs());
                }
            } else if (event instanceof IContainerEvent) {
                IContainerEvent e3 = (IContainerEvent)event;
                if (e3.getDeltaElement() == CDOEventHandler.this.view && e3.getDeltaKind() == IContainerDelta.Kind.REMOVED) {
                    CDOEventHandler.this.viewClosed();
                }
            } else if (event instanceof ILifecycleEvent && (e = (ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                CDOEventHandler.this.viewClosed();
            }
        }
    };
    private IListener viewListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOTransactionFinishedEvent) {
                try {
                    CDOEventHandler.this.treeViewer.getControl().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            try {
                                CDOEventHandler.this.treeViewer.refresh(true);
                            }
                            catch (Exception exception) {}
                        }
                    });
                }
                catch (Exception exception) {}
                CDOEventHandler.this.viewDirtyStateChanged();
            } else if (event instanceof CDOTransactionStartedEvent) {
                CDOEventHandler.this.viewDirtyStateChanged();
            } else if (event instanceof CDOTransactionConflictEvent) {
                CDOTransactionConflictEvent e = (CDOTransactionConflictEvent)event;
                CDOEventHandler.this.viewConflict(e.getConflictingObject(), e.isFirstConflict());
            }
        }
    };

    public CDOEventHandler(CDOView view, TreeViewer treeViewer) {
        this.view = view;
        this.treeViewer = treeViewer;
        view.getSession().addListener(this.sessionListener);
        view.addListener(this.viewListener);
    }

    public void dispose() {
        this.view.removeListener(this.viewListener);
        this.view.getSession().removeListener(this.sessionListener);
        this.treeViewer = null;
        this.view = null;
    }

    public CDOView getView() {
        return this.view;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setViewer(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    protected void sessionInvalidated(Set<CDOIDAndVersion> dirtyOIDs) {
        HashSet<CDOID> idsWithoutVersion = new HashSet<CDOID>();
        for (CDOIDAndVersion idAandVersion : dirtyOIDs) {
            idsWithoutVersion.add(idAandVersion.getID());
        }
        new ItemsProcessor(this.view){

            protected void processCDOObject(TreeViewer viewer, InternalCDOObject cdoObject) {
                CDOEventHandler.this.objectInvalidated(cdoObject);
                viewer.refresh((Object)cdoObject.cdoInternalInstance(), true);
            }
        }.processCDOObjects(this.treeViewer, idsWithoutVersion);
    }

    protected void objectInvalidated(InternalCDOObject cdoObject) {
    }

    protected void viewDirtyStateChanged() {
    }

    protected void viewConflict(CDOObject conflictingObject, boolean firstConflict) {
    }

    protected void viewClosed() {
    }
}

