/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.server.LockManager;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.RevisionManager;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRevisionManager;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionCommitContextImpl
implements Transaction.InternalCommitContext {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, TransactionCommitContextImpl.class);
    private TransactionPackageRegistry packageRegistry;
    private IStoreAccessor accessor;
    private long timeStamp = 0L;
    private InternalCDOPackageUnit[] newPackageUnits;
    private InternalCDORevision[] newObjects;
    private InternalCDORevision[] dirtyObjects;
    private CDOID[] detachedObjects;
    private List<CDOID> lockedObjects = new ArrayList<CDOID>();
    private List<InternalCDORevision> detachedRevisions = new ArrayList<InternalCDORevision>();
    private InternalCDORevisionDelta[] dirtyObjectDeltas;
    private List<CDOIDMetaRange> metaIDRanges = new ArrayList<CDOIDMetaRange>();
    private ConcurrentMap<CDOIDTemp, CDOID> idMappings = new ConcurrentHashMap<CDOIDTemp, CDOID>();
    private CDOReferenceAdjuster idMapper = new CDOIDMapper(this.idMappings);
    private String rollbackMessage;
    private Transaction transaction;
    private boolean autoReleaseLocksEnabled;

    public TransactionCommitContextImpl(Transaction transaction) {
        this.transaction = transaction;
        Repository repository = (Repository)transaction.getRepository();
        this.packageRegistry = new TransactionPackageRegistry(repository.getPackageRegistry(false));
        this.packageRegistry.activate();
    }

    @Override
    public int getTransactionID() {
        return this.transaction.getViewID();
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    @Override
    public InternalCDOPackageUnit[] getNewPackageUnits() {
        return this.newPackageUnits;
    }

    @Override
    public InternalCDORevision[] getNewObjects() {
        return this.newObjects;
    }

    @Override
    public InternalCDORevision[] getDirtyObjects() {
        return this.dirtyObjects;
    }

    @Override
    public CDOID[] getDetachedObjects() {
        return this.detachedObjects;
    }

    @Override
    public InternalCDORevisionDelta[] getDirtyObjectDeltas() {
        return this.dirtyObjectDeltas;
    }

    @Override
    public List<CDOIDMetaRange> getMetaIDRanges() {
        return Collections.unmodifiableList(this.metaIDRanges);
    }

    @Override
    public Map<CDOIDTemp, CDOID> getIDMappings() {
        return Collections.unmodifiableMap(this.idMappings);
    }

    @Override
    public void addIDMapping(CDOIDTemp oldID, CDOID newID) {
        if (CDOIDUtil.isNull((CDOID)newID) || newID.isTemporary()) {
            throw new IllegalStateException("newID=" + newID);
        }
        CDOID previousMapping = this.idMappings.putIfAbsent(oldID, newID);
        if (previousMapping != null) {
            throw new IllegalStateException("previousMapping != null");
        }
    }

    @Override
    public void applyIDMappings(OMMonitor monitor) {
        try {
            monitor.begin((double)(this.newObjects.length + this.dirtyObjects.length + this.dirtyObjectDeltas.length));
            this.applyIDMappings(this.newObjects, monitor.fork((double)this.newObjects.length));
            this.applyIDMappings(this.dirtyObjects, monitor.fork((double)this.dirtyObjects.length));
            InternalCDORevisionDelta[] internalCDORevisionDeltaArray = this.dirtyObjectDeltas;
            int n = this.dirtyObjectDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta dirtyObjectDelta = internalCDORevisionDeltaArray[n2];
                dirtyObjectDelta.adjustReferences(this.idMapper);
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public String getRollbackMessage() {
        return this.rollbackMessage;
    }

    @Override
    public void preCommit() {
        this.accessor = this.transaction.getRepository().getStore().getWriter(this.transaction);
        StoreThreadLocal.setAccessor(this.accessor);
        StoreThreadLocal.setCommitContext(this);
    }

    @Override
    public void setNewPackageUnits(InternalCDOPackageUnit[] newPackageUnits) {
        this.newPackageUnits = newPackageUnits;
    }

    @Override
    public void setNewObjects(InternalCDORevision[] newObjects) {
        this.newObjects = newObjects;
    }

    @Override
    public void setDirtyObjectDeltas(InternalCDORevisionDelta[] dirtyObjectDeltas) {
        this.dirtyObjectDeltas = dirtyObjectDeltas;
    }

    @Override
    public void setDetachedObjects(CDOID[] detachedObjects) {
        this.detachedObjects = detachedObjects;
    }

    @Override
    public boolean setAutoReleaseLocksEnabled(boolean on) {
        try {
            boolean bl = this.autoReleaseLocksEnabled;
            return bl;
        }
        finally {
            this.autoReleaseLocksEnabled = on;
        }
    }

    @Override
    public boolean isAutoReleaseLocksEnabled() {
        return this.autoReleaseLocksEnabled;
    }

    @Override
    public void write(OMMonitor monitor) {
        try {
            try {
                monitor.begin(106.0);
                this.timeStamp = this.createTimeStamp();
                this.dirtyObjects = new InternalCDORevision[this.dirtyObjectDeltas.length];
                this.adjustMetaRanges();
                monitor.worked();
                this.adjustTimeStamps();
                monitor.worked();
                Repository repository = (Repository)this.transaction.getRepository();
                this.computeDirtyObjects(!repository.isSupportingRevisionDeltas(), monitor.fork());
                this.lockObjects();
                monitor.worked();
                repository.notifyWriteAccessHandlers(this.transaction, this, monitor.fork());
                this.detachObjects(monitor.fork());
                this.accessor.write(this, monitor.fork(100.0));
            }
            catch (Throwable t) {
                this.handleException(t);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void commit(OMMonitor monitor) {
        try {
            try {
                monitor.begin(101.0);
                this.accessor.commit(monitor.fork(100.0));
                this.updateInfraStructure(monitor.fork());
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
                monitor.done();
            }
            catch (Error ex) {
                this.handleException(ex);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void handleException(Throwable ex) {
        OM.LOG.error(ex);
        String storeClass = this.transaction.getRepository().getStore().getClass().getSimpleName();
        this.rollback("Rollback in " + storeClass + ": " + StringUtil.formatException((Throwable)ex));
    }

    protected long createTimeStamp() {
        Repository repository = (Repository)this.transaction.getSession().getSessionManager().getRepository();
        return repository.createCommitTimeStamp();
    }

    @Override
    public void postCommit(boolean success) {
        try {
            if (success) {
                this.transaction.getRepository().getNotificationManager().notifyCommit(this.transaction.getSession(), this);
            }
        }
        finally {
            StoreThreadLocal.release();
            this.accessor = null;
            this.timeStamp = 0L;
            this.packageRegistry.deactivate();
            this.packageRegistry = null;
            this.metaIDRanges.clear();
            this.metaIDRanges = null;
            this.idMappings.clear();
            this.idMappings = null;
            this.rollbackMessage = null;
            this.newPackageUnits = null;
            this.newObjects = null;
            this.dirtyObjectDeltas = null;
            this.dirtyObjects = null;
        }
    }

    private void adjustTimeStamps() {
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.newPackageUnits;
        int n = this.newPackageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit newPackageUnit = internalCDOPackageUnitArray[n2];
            newPackageUnit.setTimeStamp(this.timeStamp);
            ++n2;
        }
        internalCDOPackageUnitArray = this.newObjects;
        n = this.newObjects.length;
        n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit newObject = internalCDOPackageUnitArray[n2];
            newObject.setCreated(this.timeStamp);
            ++n2;
        }
    }

    private void adjustMetaRanges() {
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = this.newPackageUnits;
        int n = this.newPackageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageUnit newPackageUnit = internalCDOPackageUnitArray[n2];
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = newPackageUnit.getPackageInfos();
            int n3 = internalCDOPackageInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n4];
                this.adjustMetaRange(packageInfo);
                ++n4;
            }
            ++n2;
        }
    }

    private void adjustMetaRange(InternalCDOPackageInfo packageInfo) {
        CDOIDMetaRange oldRange = packageInfo.getMetaIDRange();
        if (!oldRange.isTemporary()) {
            throw new IllegalStateException("!oldRange.isTemporary()");
        }
        int count = oldRange.size();
        CDOIDMetaRange newRange = this.transaction.getRepository().getStore().getNextMetaIDRange(count);
        packageInfo.setMetaIDRange(newRange);
        this.packageRegistry.getMetaInstanceMapper().mapMetaInstances(packageInfo.getEPackage(), newRange);
        int i = 0;
        while (i < count) {
            CDOIDTemp oldID = (CDOIDTemp)oldRange.get(i);
            CDOID newID = newRange.get(i);
            this.idMappings.put(oldID, newID);
            ++i;
        }
        this.metaIDRanges.add(newRange);
        if (TRACER.isEnabled()) {
            TRACER.format("Mapping meta ID range: {0} --> {1}", new Object[]{oldRange, newRange});
        }
    }

    private void lockObjects() throws InterruptedException {
        this.lockedObjects.clear();
        int i = 0;
        while (i < this.dirtyObjectDeltas.length) {
            this.lockedObjects.add(this.dirtyObjectDeltas[i].getID());
            ++i;
        }
        i = 0;
        while (i < this.detachedObjects.length) {
            this.lockedObjects.add(this.detachedObjects[i]);
            ++i;
        }
        try {
            LockManager lockManager = ((Repository)this.transaction.getRepository()).getLockManager();
            lockManager.lock(RWLockManager.LockType.WRITE, this.transaction, this.lockedObjects, 1000L);
        }
        catch (TimeoutRuntimeException exception) {
            this.lockedObjects.clear();
            throw exception;
        }
    }

    private synchronized void unlockObjects() {
        if (!this.lockedObjects.isEmpty()) {
            LockManager lockManager = ((Repository)this.transaction.getRepository()).getLockManager();
            lockManager.unlock(RWLockManager.LockType.WRITE, this.transaction, this.lockedObjects);
            this.lockedObjects.clear();
        }
    }

    private void computeDirtyObjects(boolean failOnNull, OMMonitor monitor) {
        try {
            monitor.begin((double)this.dirtyObjectDeltas.length);
            int i = 0;
            while (i < this.dirtyObjectDeltas.length) {
                this.dirtyObjects[i] = this.computeDirtyObject(this.dirtyObjectDeltas[i], failOnNull);
                if (this.dirtyObjects[i] == null && failOnNull) {
                    throw new IllegalStateException("Can not retrieve origin revision for " + this.dirtyObjectDeltas[i]);
                }
                monitor.worked();
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private InternalCDORevision computeDirtyObject(InternalCDORevisionDelta dirtyObjectDelta, boolean loadOnDemand) {
        CDOID id = dirtyObjectDelta.getID();
        int version = dirtyObjectDelta.getOriginVersion();
        IRevisionManager revisionResolver = this.transaction.getRepository().getRevisionManager();
        CDORevision originObject = revisionResolver.getRevisionByVersion(id, -1, version, loadOnDemand);
        if (originObject != null) {
            if (loadOnDemand) {
                EStructuralFeature[] eStructuralFeatureArray = CDOModelUtil.getAllPersistentFeatures((EClass)originObject.getEClass());
                int n = eStructuralFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature feature = eStructuralFeatureArray[n2];
                    if (feature.isMany()) {
                        InternalCDORevision internalOriginObject = (InternalCDORevision)originObject;
                        ((RevisionManager)revisionResolver).ensureChunk(internalOriginObject, feature, 0, internalOriginObject.getList(feature).size());
                    }
                    ++n2;
                }
            }
            if (!originObject.isCurrent()) {
                throw new ConcurrentModificationException("Trying to update object " + dirtyObjectDelta.getID() + " that was already modified");
            }
            InternalCDORevision dirtyObject = (InternalCDORevision)originObject.copy();
            dirtyObjectDelta.apply((CDORevision)dirtyObject);
            dirtyObject.setCreated(this.timeStamp);
            return dirtyObject;
        }
        return null;
    }

    private void applyIDMappings(InternalCDORevision[] revisions, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                if (revision != null) {
                    CDOID newID = (CDOID)this.idMappings.get(revision.getID());
                    if (newID != null) {
                        revision.setID(newID);
                    }
                    revision.adjustReferences(this.idMapper);
                    monitor.worked();
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public synchronized void rollback(String message) {
        if (this.rollbackMessage == null) {
            this.rollbackMessage = message;
            this.unlockObjects();
            if (this.accessor != null) {
                try {
                    this.accessor.rollback();
                }
                catch (RuntimeException ex) {
                    OM.LOG.warn("Problem while rolling back  the transaction", (Throwable)ex);
                }
            }
        }
    }

    protected IStoreAccessor getAccessor() {
        return this.accessor;
    }

    private void updateInfraStructure(OMMonitor monitor) {
        try {
            try {
                monitor.begin(6.0);
                this.addNewPackageUnits(monitor.fork());
                this.addRevisions((CDORevision[])this.newObjects, monitor.fork());
                this.addRevisions((CDORevision[])this.dirtyObjects, monitor.fork());
                this.revisedDetachObjects(monitor.fork());
                this.unlockObjects();
                monitor.worked();
                if (this.isAutoReleaseLocksEnabled()) {
                    ((Repository)this.transaction.getRepository()).getLockManager().unlock(this.transaction);
                }
                monitor.worked();
            }
            catch (RuntimeException runtimeException) {
                OM.LOG.error("FATAL: Memory infrastructure corrupted after successful commit operation of the store");
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewPackageUnits(OMMonitor monitor) {
        InternalCDOPackageRegistry repositoryPackageRegistry;
        Repository repository = (Repository)this.transaction.getRepository();
        InternalCDOPackageRegistry internalCDOPackageRegistry = repositoryPackageRegistry = repository.getPackageRegistry(false);
        synchronized (internalCDOPackageRegistry) {
            try {
                monitor.begin((double)this.newPackageUnits.length);
                int i = 0;
                while (i < this.newPackageUnits.length) {
                    this.newPackageUnits[i].setState(CDOPackageUnit.State.LOADED);
                    repositoryPackageRegistry.putPackageUnit(this.newPackageUnits[i]);
                    monitor.worked();
                    ++i;
                }
                repositoryPackageRegistry.getMetaInstanceMapper().mapMetaInstances(this.packageRegistry.getMetaInstanceMapper());
            }
            finally {
                monitor.done();
            }
        }
    }

    private void addRevisions(CDORevision[] revisions, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            RevisionManager revisionManager = (RevisionManager)this.transaction.getRepository().getRevisionManager();
            CDORevision[] cDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                CDORevision revision = cDORevisionArray[n2];
                if (revision != null) {
                    revisionManager.addCachedRevision((InternalCDORevision)revision);
                }
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void revisedDetachObjects(OMMonitor monitor) {
        try {
            monitor.begin((double)this.detachedRevisions.size());
            for (InternalCDORevision revision : this.detachedRevisions) {
                revision.setRevised(this.getTimeStamp() - 1L);
                monitor.worked();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void detachObjects(OMMonitor monitor) {
        this.detachedRevisions.clear();
        RevisionManager revisionManager = (RevisionManager)this.transaction.getRepository().getRevisionManager();
        CDOID[] detachedObjects = this.getDetachedObjects();
        try {
            monitor.begin((double)detachedObjects.length);
            CDOID[] cDOIDArray = detachedObjects;
            int n = detachedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                CDOID id = cDOIDArray[n2];
                InternalCDORevision revision = revisionManager.getRevision(id, -1, false);
                if (revision != null) {
                    this.detachedRevisions.add(revision);
                }
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static final class TransactionPackageRegistry
    extends CDOPackageRegistryImpl {
        private static final long serialVersionUID = 1L;

        public TransactionPackageRegistry(InternalCDOPackageRegistry repositoryPackageRegistry) {
            this.delegateRegistry = repositoryPackageRegistry;
            this.setPackageLoader(repositoryPackageRegistry.getPackageLoader());
        }

        public void putPackageUnit(InternalCDOPackageUnit packageUnit) {
            packageUnit.setPackageRegistry((InternalCDOPackageRegistry)this);
            InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageUnit.getPackageInfos();
            int n = internalCDOPackageInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
                EPackage ePackage = packageInfo.getEPackage();
                this.basicPut(ePackage.getNsURI(), ePackage);
                ++n2;
            }
            this.resetInternalCaches();
        }

        protected void disposePackageUnits() {
        }
    }
}

