/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.MEMStore;
import org.eclipse.emf.cdo.internal.server.MEMStoreAccessor;
import org.eclipse.emf.cdo.internal.server.StoreChunkReader;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.IStoreReader;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEMStoreChunkReader
extends StoreChunkReader {
    public MEMStoreChunkReader(IStoreReader storeReader, CDORevision revision, CDOFeature feature) {
        super(storeReader, revision, feature);
    }

    @Override
    public List<IStoreChunkReader.Chunk> executeRead() {
        MEMStore store = this.getStoreReader().getStore();
        List<IStoreChunkReader.Chunk> chunks = this.getChunks();
        for (IStoreChunkReader.Chunk chunk : chunks) {
            int startIndex = chunk.getStartIndex();
            InternalCDORevision revision = (InternalCDORevision)store.getRevision(this.getRevision().getID());
            int i = 0;
            while (i < chunk.size()) {
                Object object = revision.get(this.getFeature(), startIndex + i);
                chunk.addID(i, (CDOID)object);
                ++i;
            }
        }
        return chunks;
    }

    @Override
    public MEMStoreAccessor getStoreReader() {
        return (MEMStoreAccessor)super.getStoreReader();
    }
}

