/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedHibernateList
implements InternalCDOList {
    private List<Object> delegate;

    public Object move(int targetIndex, int sourceIndex) {
        int size = this.size();
        if (sourceIndex >= size) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + size);
        }
        if (targetIndex >= size) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + size);
        }
        Object object = this.get(sourceIndex);
        if (targetIndex == sourceIndex) {
            return object;
        }
        if (targetIndex < sourceIndex) {
            this.moveUp1(targetIndex, sourceIndex - targetIndex);
        } else {
            this.moveDown1(targetIndex, targetIndex - sourceIndex);
        }
        this.set(targetIndex, object);
        return object;
    }

    private void moveUp1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index + i, this.get(index + i - 1));
            --i;
        }
    }

    private void moveDown1(int index, int count) {
        int i = count;
        while (i > 0) {
            this.set(index - i, this.get(index - i + 1));
            --i;
        }
    }

    public void adjustReferences(CDOReferenceAdjuster adjuster, EStructuralFeature feature) {
        CDOType type = CDOModelUtil.getType((EStructuralFeature)feature);
        int size = this.size();
        int i = 0;
        while (i < size) {
            Object element = this.get(i);
            Object newID = type.adjustReferences(adjuster, element);
            if (newID != element) {
                this.set(i, newID);
            }
            ++i;
        }
    }

    public InternalCDOList clone(EClassifier classifier) {
        CDOType type = CDOModelUtil.getType((EClassifier)classifier);
        int size = this.size();
        InternalCDOList list = (InternalCDOList)CDOListFactory.DEFAULT.createList(size, 0, 0);
        int i = 0;
        while (i < size) {
            list.add(type.copyValue(this.get(i)));
            ++i;
        }
        return list;
    }

    public List<Object> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(List<Object> delegate) {
        this.delegate = delegate;
    }

    protected Object getObject(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof CDOID)) {
            return o;
        }
        return HibernateUtil.getInstance().getCDORevision((CDOID)o);
    }

    protected List<Object> getObjects(List<?> cdoIDs) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : cdoIDs) {
            result.add(this.getObject(o));
        }
        return result;
    }

    protected CDOID getCDOID(Object o) {
        CDORevision cdoRevision = (CDORevision)o;
        return cdoRevision.getID();
    }

    protected List<CDOID> getCDOIDs(Collection<?> c) {
        ArrayList<CDOID> newC = new ArrayList<CDOID>();
        for (Object o : c) {
            newC.add(this.getCDOID(o));
        }
        return newC;
    }

    public void add(int index, Object element) {
        this.getDelegate().add(index, this.getCDOID(element));
    }

    public boolean add(Object o) {
        return this.getDelegate().add(this.getCDOID(o));
    }

    public boolean addAll(Collection<? extends Object> c) {
        return this.getDelegate().addAll(this.getCDOIDs(c));
    }

    public boolean addAll(int index, Collection<? extends Object> c) {
        return this.getDelegate().addAll(index, this.getCDOIDs(c));
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public boolean contains(Object o) {
        return this.getDelegate().contains(this.getCDOID(o));
    }

    public boolean containsAll(Collection<?> c) {
        return this.getDelegate().containsAll(this.getCDOIDs(c));
    }

    public Object get(int index) {
        Object value = this.getObject(this.getDelegate().get(index));
        if (value instanceof CDORevision) {
            return ((CDORevision)value).getID();
        }
        return value;
    }

    public Object get(int index, boolean resolve) {
        return this.get(index);
    }

    public int indexOf(Object o) {
        return this.getDelegate().indexOf(this.getCDOID(o));
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public Iterator<Object> iterator() {
        return new CDOHibernateIterator(this.getDelegate().iterator());
    }

    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(this.getCDOID(o));
    }

    public ListIterator<Object> listIterator() {
        return new CDOHibernateListIterator(this.getDelegate().listIterator());
    }

    public ListIterator<Object> listIterator(int index) {
        return new CDOHibernateListIterator(this.getDelegate().listIterator(index));
    }

    public Object remove(int index) {
        return this.getDelegate().remove(index);
    }

    public boolean remove(Object o) {
        return this.getDelegate().remove(this.getCDOID(o));
    }

    public boolean removeAll(Collection<?> c) {
        return this.getDelegate().removeAll(this.getCDOIDs(c));
    }

    public boolean retainAll(Collection<?> c) {
        return this.getDelegate().retainAll(this.getCDOIDs(c));
    }

    public Object set(int index, Object element) {
        if (element instanceof CDOID) {
            return this.getDelegate().set(index, element);
        }
        return this.getDelegate().set(index, this.getCDOID(element));
    }

    public int size() {
        return this.getDelegate().size();
    }

    public List<Object> subList(int fromIndex, int toIndex) {
        return this.getObjects(this.getDelegate().subList(fromIndex, toIndex));
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        Iterator<Object> iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            result[i++] = o;
        }
        return result;
    }

    public <T> T[] toArray(T[] a) {
        int i = 0;
        Iterator<Object> iterator = this.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            a[i++] = o;
        }
        return a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CDOHibernateIterator
    implements Iterator<Object> {
        private final Iterator<?> delegate;

        public CDOHibernateIterator(Iterator<?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object next() {
            Object o = this.delegate.next();
            if (o instanceof CDOID) {
                return HibernateUtil.getInstance().getCDORevision((CDOID)o);
            }
            return o;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CDOHibernateListIterator
    implements ListIterator<Object> {
        private final ListIterator<Object> delegate;

        public CDOHibernateListIterator(ListIterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void add(Object o) {
            this.delegate.add(((CDORevision)o).getID());
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public Object next() {
            Object o = this.delegate.next();
            if (o instanceof CDOID) {
                return HibernateUtil.getInstance().getCDORevision((CDOID)this.delegate.next());
            }
            return o;
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public Object previous() {
            Object o = this.delegate.previous();
            if (o instanceof CDOID) {
                return HibernateUtil.getInstance().getCDORevision((CDOID)this.delegate.next());
            }
            return o;
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void set(Object o) {
            this.delegate.set(((CDORevision)o).getID());
        }
    }
}

