/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.server.IPackageManager;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreReader;
import org.eclipse.emf.cdo.server.db.IObjectTypeCache;
import org.eclipse.emf.cdo.server.internal.db.HorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.MappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.ObjectTypeCache;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalMappingStrategy
extends MappingStrategy {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HorizontalMappingStrategy.class);
    private IObjectTypeCache objectTypeCache;

    @Override
    public String getType() {
        return "horizontal";
    }

    public IObjectTypeCache getObjectTypeCache() {
        return this.objectTypeCache;
    }

    public void setObjectTypeCache(IObjectTypeCache objectTypeCache) {
        this.objectTypeCache = objectTypeCache;
    }

    @Override
    public CDOClassRef readObjectType(IDBStoreReader storeReader, CDOID id) {
        return this.objectTypeCache.getObjectType(storeReader, id);
    }

    protected CDOClassRef readObjectTypeFromClassesWithObjectInfo(IDBStoreReader storeReader, CDOID id) {
        String prefix = "SELECT DISTINCT cdo_class FROM ";
        String suffix = " WHERE cdo_id=" + id;
        for (CDOClass cdoClass : this.getClassesWithObjectInfo()) {
            ResultSet resultSet;
            block6: {
                CDOClassRef cDOClassRef;
                IDBTable table;
                IClassMapping mapping = this.getClassMapping(cdoClass);
                if (mapping == null || (table = mapping.getTable()) == null) continue;
                String sql = String.valueOf(prefix) + table + suffix;
                if (TRACER.isEnabled()) {
                    TRACER.trace(sql);
                }
                resultSet = null;
                try {
                    resultSet = storeReader.getStatement().executeQuery(sql);
                    if (!resultSet.next()) break block6;
                    int classID = resultSet.getInt(1);
                    cDOClassRef = this.getClassRef(storeReader, classID);
                }
                catch (SQLException ex) {
                    try {
                        throw new DBException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        DBUtil.close(resultSet);
                        throw throwable;
                    }
                }
                DBUtil.close((ResultSet)resultSet);
                return cDOClassRef;
            }
            DBUtil.close((ResultSet)resultSet);
        }
        throw new DBException("No object with id " + id);
    }

    @Override
    protected IClassMapping createClassMapping(CDOClass cdoClass) {
        if (cdoClass.isAbstract()) {
            return null;
        }
        return new HorizontalClassMapping(this, cdoClass);
    }

    @Override
    protected List<CDOClass> getClassesWithObjectInfo() {
        ArrayList<CDOClass> result = new ArrayList<CDOClass>();
        IPackageManager packageManager = this.getStore().getRepository().getPackageManager();
        CDOPackage[] cDOPackageArray = packageManager.getPackages();
        int n = cDOPackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackage cdoPackage = cDOPackageArray[n2];
            CDOClass[] cDOClassArray = cdoPackage.getConcreteClasses();
            int n3 = cDOClassArray.length;
            int n4 = 0;
            while (n4 < n3) {
                CDOClass cdoClass = cDOClassArray[n4];
                if (!cdoClass.isRoot()) {
                    result.add(cdoClass);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.objectTypeCache == null) {
            this.objectTypeCache = this.createObjectTypeCache(this.getStore());
            LifecycleUtil.activate((Object)this.objectTypeCache);
        }
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.objectTypeCache);
        this.objectTypeCache = null;
        super.doDeactivate();
    }

    protected IObjectTypeCache createObjectTypeCache(IDBStore store) {
        ObjectTypeCache cache = new ObjectTypeCache();
        cache.setMappingStrategy(this);
        return cache;
    }
}

