/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.internal.server.LongIDStore;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreReader;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreUtil;
import org.eclipse.emf.cdo.server.db.IClassMapping;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.DBStoreReader;
import org.eclipse.emf.cdo.server.internal.db.DBStoreWriter;
import org.eclipse.emf.cdo.server.internal.db.MappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.DBSchema;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class DBStore
extends LongIDStore
implements IDBStore {
    public static final String TYPE = "db";
    private IMappingStrategy mappingStrategy;
    private IDBSchema dbSchema;
    private IDBAdapter dbAdapter;
    private IDBConnectionProvider dbConnectionProvider;
    private int nextPackageID;
    private int nextClassID;
    private int nextFeatureID;

    public DBStore() {
        super(TYPE);
    }

    public IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        mappingStrategy.setStore(this);
    }

    public IDBAdapter getDBAdapter() {
        return this.dbAdapter;
    }

    public void setDbAdapter(IDBAdapter dbAdapter) {
        this.dbAdapter = dbAdapter;
    }

    public IDBConnectionProvider getDBConnectionProvider() {
        return this.dbConnectionProvider;
    }

    public void setDbConnectionProvider(IDBConnectionProvider dbConnectionProvider) {
        this.dbConnectionProvider = dbConnectionProvider;
    }

    public void setDataSource(DataSource dataSource) {
        this.dbConnectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
    }

    public synchronized IDBSchema getDBSchema() {
        if (this.dbSchema == null) {
            this.dbSchema = this.createSchema();
        }
        return this.dbSchema;
    }

    public boolean hasAuditingSupport() {
        return true;
    }

    public boolean hasBranchingSupport() {
        return false;
    }

    public boolean hasWriteDeltaSupport() {
        return false;
    }

    public DBStoreReader getReader(ISession session) {
        return (DBStoreReader)super.getReader(session);
    }

    public DBStoreReader createReader(ISession session) throws DBException {
        return new DBStoreReader(this, session);
    }

    public DBStoreWriter getWriter(IView view) {
        return (DBStoreWriter)super.getWriter(view);
    }

    public DBStoreWriter createWriter(IView view) throws DBException {
        return new DBStoreWriter(this, view);
    }

    public synchronized int getNextPackageID() {
        return this.nextPackageID++;
    }

    public synchronized int getNextClassID() {
        return this.nextClassID++;
    }

    public synchronized int getNextFeatureID() {
        return this.nextFeatureID++;
    }

    public Connection getConnection() {
        Connection connection = this.dbConnectionProvider.getConnection();
        if (connection == null) {
            throw new DBException("No connection from connection provider: " + this.dbConnectionProvider);
        }
        return connection;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkNull(this.mappingStrategy, "mappingStrategy is null");
        this.checkNull(this.dbAdapter, "dbAdapter is null");
        this.checkNull(this.dbConnectionProvider, "dbConnectionProvider is null");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        Connection connection = null;
        try {
            connection = this.getConnection();
            Set createdTables = CDODBSchema.INSTANCE.create(this.dbAdapter, this.dbConnectionProvider);
            if (createdTables.contains(CDODBSchema.REPOSITORY)) {
                DBUtil.insertRow((Connection)connection, (IDBAdapter)this.dbAdapter, (IDBTable)CDODBSchema.REPOSITORY, (Object[])new Object[]{1, this.getStartupTime(), 0, -1L, -1L});
                MappingStrategy mappingStrategy = (MappingStrategy)this.getMappingStrategy();
                IClassMapping resourceClassMapping = mappingStrategy.getResourceClassMapping();
                Set<IDBTable> tables = resourceClassMapping.getAffectedTables();
                if (this.dbAdapter.createTables(tables, connection).size() != tables.size()) {
                    throw new DBException("CDOResource tables not completely created");
                }
            } else {
                long lastObjectID = DBUtil.selectMaximumLong((Connection)connection, (IDBField)CDODBSchema.REPOSITORY_NEXT_CDOID);
                this.setLastMetaID(DBUtil.selectMaximumLong((Connection)connection, (IDBField)CDODBSchema.REPOSITORY_NEXT_METAID));
                if (lastObjectID == -1L || this.getLastMetaID() == -1L) {
                    OM.LOG.warn("Detected restart after crash");
                }
                this.setLastObjectID(lastObjectID);
                StringBuilder builder = new StringBuilder();
                builder.append("UPDATE ");
                builder.append(CDODBSchema.REPOSITORY);
                builder.append(" SET ");
                builder.append(CDODBSchema.REPOSITORY_STARTS);
                builder.append("=");
                builder.append(CDODBSchema.REPOSITORY_STARTS);
                builder.append("+1, ");
                builder.append(CDODBSchema.REPOSITORY_STARTED);
                builder.append("=");
                builder.append(this.getStartupTime());
                builder.append(", ");
                builder.append(CDODBSchema.REPOSITORY_STOPPED);
                builder.append("=0, ");
                builder.append(CDODBSchema.REPOSITORY_NEXT_CDOID);
                builder.append("=");
                builder.append(-1L);
                builder.append(", ");
                builder.append(CDODBSchema.REPOSITORY_NEXT_METAID);
                builder.append("=");
                builder.append(-1L);
                String sql = builder.toString();
                int count = DBUtil.update((Connection)connection, (String)sql);
                if (count == 0) {
                    throw new DBException("No row updated in table " + CDODBSchema.REPOSITORY);
                }
            }
            this.nextPackageID = DBUtil.selectMaximumInt((Connection)connection, (IDBField)CDODBSchema.PACKAGES_ID) + 1;
            this.nextClassID = DBUtil.selectMaximumInt((Connection)connection, (IDBField)CDODBSchema.CLASSES_ID) + 1;
            this.nextFeatureID = DBUtil.selectMaximumInt((Connection)connection, (IDBField)CDODBSchema.FEATURES_ID) + 1;
            LifecycleUtil.activate((Object)this.mappingStrategy);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    protected void doDeactivate() throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection();
            LifecycleUtil.deactivate((Object)this.mappingStrategy);
            StringBuilder builder = new StringBuilder();
            builder.append("UPDATE ");
            builder.append(CDODBSchema.REPOSITORY);
            builder.append(" SET ");
            builder.append(CDODBSchema.REPOSITORY_STOPPED);
            builder.append("=");
            builder.append(this.getShutdownTime());
            builder.append(", ");
            builder.append(CDODBSchema.REPOSITORY_NEXT_CDOID);
            builder.append("=");
            builder.append(this.getLastObjectID());
            builder.append(", ");
            builder.append(CDODBSchema.REPOSITORY_NEXT_METAID);
            builder.append("=");
            builder.append(this.getRepository().getLastMetaID());
            String sql = builder.toString();
            int count = DBUtil.update((Connection)connection, (String)sql);
            if (count == 0) {
                throw new DBException("No row updated in table " + CDODBSchema.REPOSITORY);
            }
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        super.doDeactivate();
    }

    public void repairAfterCrash() {
        DBStoreReader storeReader = this.getReader(null);
        StoreUtil.setReader((IStoreReader)storeReader);
        try {
            Connection connection = storeReader.getConnection();
            long maxObjectID = this.mappingStrategy.repairAfterCrash(connection);
            this.setLastMetaID(DBUtil.selectMaximumLong((Connection)connection, (IDBField)CDODBSchema.PACKAGES_RANGE_UB));
            OM.LOG.info(MessageFormat.format("Repaired after crash: maxObjectID={0}, maxMetaID={1}", maxObjectID, this.getLastMetaID()));
            this.setLastObjectID(maxObjectID);
        }
        finally {
            storeReader.release();
            StoreUtil.setReader(null);
        }
    }

    protected IDBSchema createSchema() {
        String name = this.getRepository().getName();
        return new DBSchema(name);
    }

    protected long getStartupTime() {
        return System.currentTimeMillis();
    }

    protected long getShutdownTime() {
        return System.currentTimeMillis();
    }

    public static DBType getDBType(CDOType type) {
        if (type == CDOType.BOOLEAN || type == CDOType.BOOLEAN_OBJECT) {
            return DBType.BOOLEAN;
        }
        if (type == CDOType.BYTE || type == CDOType.BYTE_OBJECT) {
            return DBType.SMALLINT;
        }
        if (type == CDOType.CHAR || type == CDOType.CHARACTER_OBJECT) {
            return DBType.CHAR;
        }
        if (type == CDOType.DATE) {
            return DBType.DATE;
        }
        if (type == CDOType.DOUBLE || type == CDOType.DOUBLE_OBJECT) {
            return DBType.DOUBLE;
        }
        if (type == CDOType.FLOAT || type == CDOType.FLOAT_OBJECT) {
            return DBType.FLOAT;
        }
        if (type == CDOType.INT || type == CDOType.INTEGER_OBJECT) {
            return DBType.INTEGER;
        }
        if (type == CDOType.LONG || type == CDOType.LONG_OBJECT) {
            return DBType.BIGINT;
        }
        if (type == CDOType.OBJECT) {
            return DBType.BIGINT;
        }
        if (type == CDOType.SHORT || type == CDOType.SHORT_OBJECT) {
            return DBType.SMALLINT;
        }
        if (type == CDOType.STRING || type == CDOType.CUSTOM) {
            return DBType.VARCHAR;
        }
        throw new ImplementationError("Unrecognized CDOType: " + type);
    }
}

