/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListIndexAffecting;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListTargetAdding;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOListFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOListFeatureDelta {
    private List<CDOFeatureDelta> featureDeltas = new ArrayList<CDOFeatureDelta>();

    public CDOListFeatureDeltaImpl(CDOFeature feature) {
        super(feature);
    }

    public CDOListFeatureDeltaImpl(ExtendedDataInput in, CDOClass cdoClass) throws IOException {
        super(in, cdoClass);
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            this.featureDeltas.add(CDOFeatureDeltaImpl.read(in, cdoClass));
            ++i;
        }
    }

    @Override
    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.LIST;
    }

    @Override
    public List<CDOFeatureDelta> getListChanges() {
        return this.featureDeltas;
    }

    @Override
    public void write(ExtendedDataOutput out, CDOClass cdoClass, CDOIDProvider idProvider) throws IOException {
        super.write(out, cdoClass, idProvider);
        out.writeInt(this.featureDeltas.size());
        for (CDOFeatureDelta featureDelta : this.featureDeltas) {
            ((CDOFeatureDeltaImpl)featureDelta).write(out, cdoClass, idProvider);
        }
    }

    public int[] reconstructAddedIndices() {
        int[] indices = new int[1 + this.featureDeltas.size()];
        for (CDOFeatureDelta featureDelta : this.featureDeltas) {
            if (featureDelta instanceof IListIndexAffecting) {
                IListIndexAffecting affecting = (IListIndexAffecting)((Object)featureDelta);
                affecting.affectIndices(indices);
            }
            if (!(featureDelta instanceof IListTargetAdding)) continue;
            indices[0] = indices[0] + 1;
            indices[indices[0]] = ((IListTargetAdding)((Object)featureDelta)).getIndex();
        }
        return indices;
    }

    public void add(CDOFeatureDelta featureDelta) {
        this.featureDeltas.add(featureDelta);
    }

    @Override
    public void apply(CDORevision revision) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas) {
            ((CDOFeatureDeltaImpl)featureDelta).apply(revision);
        }
    }

    @Override
    public void adjustReferences(Map<CDOIDTemp, CDOID> idMappings) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas) {
            ((CDOFeatureDeltaImpl)featureDelta).adjustReferences(idMappings);
        }
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }
}

