/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.model.core.CDOCorePackage;
import org.eclipse.emf.cdo.common.model.resource.CDOResourcePackage;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.model.core.CDOCorePackageImpl;
import org.eclipse.emf.cdo.internal.common.model.resource.CDOResourcePackageImpl;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOPackageManagerImpl
extends Container<CDOPackage>
implements CDOPackageManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_MODEL, CDOPackageManagerImpl.class);
    private ConcurrentMap<String, CDOPackage> packages = new ConcurrentHashMap<String, CDOPackage>();
    private CDOCorePackage cdoCorePackage = new CDOCorePackageImpl(this);
    private CDOResourcePackage cdoResourcePackage;

    public CDOPackageManagerImpl() {
        this.addPackage(this.cdoCorePackage);
        this.cdoResourcePackage = new CDOResourcePackageImpl(this);
        this.addPackage(this.cdoResourcePackage);
    }

    @Override
    public CDOPackage lookupPackage(String uri) {
        if (uri == null) {
            return null;
        }
        return (CDOPackage)this.packages.get(uri);
    }

    @Override
    public int getPackageCount() {
        return this.packages.size();
    }

    @Override
    public CDOPackage[] getPackages() {
        return this.packages.values().toArray(new CDOPackage[this.packages.size()]);
    }

    public CDOPackage[] getElements() {
        return this.getPackages();
    }

    public boolean isEmpty() {
        return this.packages.isEmpty();
    }

    @Override
    public CDOCorePackage getCDOCorePackage() {
        return this.cdoCorePackage;
    }

    @Override
    public CDOResourcePackage getCDOResourcePackage() {
        return this.cdoResourcePackage;
    }

    public List<CDOPackage> getTransientPackages() {
        ArrayList<CDOPackage> result = new ArrayList<CDOPackage>();
        for (CDOPackage cdoPackage : this.packages.values()) {
            if (cdoPackage.isPersistent()) continue;
            result.add(cdoPackage);
        }
        return result;
    }

    public void addPackage(CDOPackage cdoPackage) {
        String uri = cdoPackage.getPackageURI();
        if (uri == null) {
            throw new IllegalArgumentException("uri == null");
        }
        CDOPackage existing = this.packages.putIfAbsent(uri, cdoPackage);
        if (existing == null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Added package: {0}", new Object[]{cdoPackage});
            }
        } else {
            throw new IllegalStateException("Duplicate package: " + cdoPackage);
        }
        this.fireElementAddedEvent(cdoPackage);
    }

    public void removePackage(CDOPackage cdoPackage) {
        this.packages.remove(cdoPackage.getPackageURI());
        this.fireElementRemovedEvent(cdoPackage);
    }

    protected abstract void resolve(CDOPackage var1);

    protected abstract String provideEcore(CDOPackage var1);
}

