/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;

public final class CDOClassProxy {
    private CDOPackageManager packageManager;
    private CDOClassRef classRef;
    private CDOClass cdoClass;

    public CDOClassProxy() {
    }

    public CDOClassProxy(CDOClassRef classRef, CDOPackageManager packageManager) {
        this.classRef = classRef;
        this.packageManager = packageManager;
    }

    public CDOClassProxy(CDOClass cdoClass) {
        this.cdoClass = cdoClass;
    }

    public String getPackageURI() {
        if (this.cdoClass == null) {
            return this.classRef.getPackageURI();
        }
        return this.cdoClass.getContainingPackage().getPackageURI();
    }

    public int getClassifierID() {
        if (this.cdoClass == null) {
            return this.classRef.getClassifierID();
        }
        return this.cdoClass.getClassifierID();
    }

    public void setCDOPackageManager(CDOPackageManager packageManager) {
        this.packageManager = packageManager;
    }

    public CDOClass getCdoClass() {
        if (this.cdoClass == null) {
            this.cdoClass = this.classRef.resolve(this.packageManager);
            if (this.cdoClass == null) {
                throw new IllegalStateException("Unable to resolve class ref: " + this.classRef);
            }
        }
        return this.cdoClass;
    }

    public void setCdoClass(CDOClass cdoClass) {
        this.cdoClass = cdoClass;
    }

    public CDOClassRef getClassRef() {
        if (this.classRef == null) {
            this.classRef = this.cdoClass.createClassRef();
        }
        return this.classRef;
    }

    public String toString() {
        if (this.cdoClass != null) {
            return this.cdoClass.toString();
        }
        return this.classRef.toString();
    }
}

