/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.type;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.Constants;
import org.eclipse.emf.teneo.type.FeatureMapEntry;

public abstract class MixedFeatureMapEntry
extends FeatureMapEntry {
    private static final long serialVersionUID = 1L;
    static final String TEXT_FEATURE_DBID = "TEXT";
    static final String CDATA_FEATURE_DBID = "CDATA";
    static final String COMMENT_FEATURE_DBID = "COMMENT";

    protected String createStructuralFeatureDBID() {
        EStructuralFeature structuralFeature = this.getEStructuralFeature();
        if (structuralFeature == Constants.TEXT) {
            return TEXT_FEATURE_DBID;
        }
        if (structuralFeature == Constants.CDATA) {
            return CDATA_FEATURE_DBID;
        }
        if (structuralFeature == Constants.COMMENT) {
            return COMMENT_FEATURE_DBID;
        }
        return super.createStructuralFeatureDBID();
    }

    protected EStructuralFeature retrieveStructuralFeature(String dbid) {
        if (TEXT_FEATURE_DBID.compareTo(dbid) == 0) {
            return Constants.TEXT;
        }
        if (CDATA_FEATURE_DBID.compareTo(dbid) == 0) {
            return Constants.CDATA;
        }
        if (COMMENT_FEATURE_DBID.compareTo(dbid) == 0) {
            return Constants.COMMENT;
        }
        return super.retrieveStructuralFeature(dbid);
    }

    protected boolean isMixedFeature() {
        EStructuralFeature structuralFeature = this.getEStructuralFeature();
        return structuralFeature == Constants.TEXT || structuralFeature == Constants.CDATA || structuralFeature == Constants.COMMENT;
    }
}

