/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.ide.ui.internal.editor.PropertySheetAdapterFactory;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry.ModelResolverRegistry;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry.ModelResolverRegistryListener;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

public class EMFCompareIDEUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.compare.ide.ui";
    private static EMFCompareIDEUIPlugin plugin;
    private static final String MODEL_RESOLVER_PPID = "modelResolvers";
    private AbstractRegistryEventListener modelResolverRegistryListener;
    private ModelResolverRegistry modelResolverRegistry;
    private static Map<String, Image> resourcesMapper;
    private InstanceScope instanceScope = new InstanceScope();

    static {
        resourcesMapper = new HashMap<String, Image>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IExtensionRegistry globalRegistry = Platform.getExtensionRegistry();
        this.modelResolverRegistry = new ModelResolverRegistry((Preferences)this.instanceScope.getNode(PLUGIN_ID));
        this.modelResolverRegistryListener = new ModelResolverRegistryListener(PLUGIN_ID, MODEL_RESOLVER_PPID, this.getLog(), this.modelResolverRegistry);
        globalRegistry.addListener((IRegistryEventListener)this.modelResolverRegistryListener);
        this.modelResolverRegistryListener.readRegistry(globalRegistry);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)new PropertySheetAdapterFactory(), CompareEditor.class);
    }

    public void stop(BundleContext context) throws Exception {
        IExtensionRegistry globalRegistry = Platform.getExtensionRegistry();
        globalRegistry.removeListener((IRegistryEventListener)this.modelResolverRegistryListener);
        this.modelResolverRegistry.clear();
        plugin = null;
        super.stop(context);
    }

    public static EMFCompareIDEUIPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String imagePath) {
        Image image = resourcesMapper.get(imagePath);
        if (image == null) {
            ImageDescriptor imageDescriptor = EMFCompareIDEUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imagePath);
            image = imageDescriptor.createImage();
            resourcesMapper.put(imagePath, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String imagePath) {
        return EMFCompareIDEUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imagePath);
    }

    public static void disposeImage(String id) {
        Image image = resourcesMapper.remove(id);
        if (image != null) {
            image.dispose();
        }
    }

    public static void disposeCachedImages() {
        Iterator<Image> iterator = resourcesMapper.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        resourcesMapper.clear();
    }

    public ModelResolverRegistry getModelResolverRegistry() {
        return this.modelResolverRegistry;
    }

    public void log(Throwable e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public void log(int severity, String message) {
        this.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
    }
}

