/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URL;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.RolesEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TokenAgeTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = TokenAgeTest.class.getResource("/META-INF/microprofile-config-verify-token-age.properties");
        URL publicKey = TokenAgeTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"TokenAgeTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_2_1.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(RolesEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with aged token fails with HTTP_UNAUTHORIZED")
    public void callEchoAgedToken() throws Exception {
        String token = TokenUtils.generateTokenString((String)"/Token1.json");
        Thread.sleep(5000L);
        this.callEchoAndExpectStatus(token, 401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with valid token succeeds with HTTP_OK")
    public void callEchoValidToken() throws Exception {
        String token = TokenUtils.generateTokenString((String)"/Token1.json");
        this.callEchoAndExpectStatus(token, 200);
    }

    private void callEchoAndExpectStatus(String token, int status) throws Exception {
        Response response = this.callEcho(token);
        Assert.assertEquals((int)response.getStatus(), (int)status);
        String reply = (String)response.readEntity(String.class);
        System.out.printf("Reply: %s\n", reply);
    }

    private Response callEcho(String token) throws Exception {
        System.out.printf("jwt: %s\n", token);
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        return echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
    }
}

