/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;

@Path(value="/endp")
@RequestScoped
@RolesAllowed(value={"Tester"})
public class PrimitiveInjectionEndpoint {
    @Inject
    @Claim(value="raw_token")
    private String rawToken;
    @Inject
    @Claim(value="iss")
    private String issuer;
    @Inject
    @Claim(value="upn")
    private String upn;
    @Inject
    @Claim(value="jti")
    private String jti;
    @Inject
    @Claim(value="aud")
    private Set<String> aud;
    @Inject
    @Claim(value="groups")
    private Set<String> groups;
    @Inject
    @Claim(value="iat")
    private long issuedAt;
    @Inject
    @Claim(value="iat")
    private Long issuedAtWrapper;
    @Inject
    @Claim(value="exp")
    private long expiration;
    @Inject
    @Claim(value="sub")
    private String subject;
    @Inject
    @Claim(value="customString")
    private String customString;
    @Inject
    @Claim(value="customBoolean")
    private Boolean customBooleanWrapper;
    @Inject
    @Claim(value="customBoolean")
    private boolean customBoolean;

    @GET
    @Path(value="/verifyInjectedIssuer")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedIssuer(@QueryParam(value="iss") String iss) {
        String msg;
        boolean pass = false;
        String issValue = this.issuer;
        if (issValue == null || issValue.length() == 0) {
            msg = Claims.iss.name() + "value is null or empty, FAIL";
        } else if (issValue.equals(iss)) {
            msg = Claims.iss.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iss.name(), issValue, iss);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedRawToken")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedRawToken(@QueryParam(value="raw_token") String rt) {
        String msg;
        boolean pass = false;
        String rawTokenValue = this.rawToken;
        if (rawTokenValue == null || rawTokenValue.length() == 0) {
            msg = Claims.raw_token.name() + "value is null or empty, FAIL";
        } else if (rawTokenValue.equals(rt)) {
            msg = Claims.raw_token.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.raw_token.name(), rawTokenValue, rt);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedJTI")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedJTI(@QueryParam(value="jti") String jwtID) {
        String msg;
        boolean pass = false;
        String jtiValue = this.jti;
        if (jtiValue == null || jtiValue.length() == 0) {
            msg = Claims.jti.name() + "value is null or empty, FAIL";
        } else if (jtiValue.equals(jwtID)) {
            msg = Claims.jti.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.jti.name(), jtiValue, jwtID);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedUPN")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedUPN(@QueryParam(value="upn") String upn) {
        String msg;
        boolean pass = false;
        String upnValue = this.upn;
        if (upnValue == null || upnValue.length() == 0) {
            msg = Claims.upn.name() + "value is null or empty, FAIL";
        } else if (upnValue.equals(upn)) {
            msg = Claims.upn.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.upn.name(), upnValue, upn);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedSUB")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedSUB(@QueryParam(value="sub") String sub) {
        String msg;
        boolean pass = false;
        String subValue = this.subject;
        if (subValue == null || subValue.length() == 0) {
            msg = Claims.sub.name() + "value is null or empty, FAIL";
        } else if (subValue.equals(sub)) {
            msg = Claims.sub.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.sub.name(), subValue, sub);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedAudience")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedAudience(@QueryParam(value="aud") String audience) {
        String msg;
        boolean pass = false;
        Set<String> audValue = this.aud;
        if (audValue == null || audValue.size() == 0) {
            msg = Claims.aud.name() + "value is null or empty, FAIL";
        } else if (audValue.contains(audience)) {
            msg = Claims.aud.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.aud.name(), audValue, audience);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedGroups")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedGroups(@QueryParam(value="groups") List<String> groups) {
        String msg;
        boolean pass = false;
        Set<String> groupsValue = this.groups;
        if (groupsValue == null || groupsValue.size() == 0) {
            msg = Claims.groups.name() + "value is null or empty, FAIL";
        } else if (groupsValue.containsAll(groups)) {
            msg = Claims.groups.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.groups.name(), groupsValue, groups);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedIssuedAt")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedIssuedAt(@QueryParam(value="iat") Long iat) {
        String msg;
        boolean pass = false;
        Long iatValue = this.issuedAtWrapper;
        if (iatValue == null || iatValue.intValue() == 0 || iatValue != this.issuedAt) {
            msg = Claims.iat.name() + "value is null or empty, FAIL";
        } else if (iatValue.equals(iat)) {
            msg = Claims.iat.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iat.name(), iatValue, iat);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedExpiration")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedExpiration(@QueryParam(value="exp") Long exp) {
        String msg;
        boolean pass = false;
        Long expValue = this.expiration;
        if (expValue == null || expValue.intValue() == 0) {
            msg = Claims.exp.name() + "value is null or empty, FAIL";
        } else if (expValue.equals(exp)) {
            msg = Claims.exp.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.exp.name(), expValue, exp);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomString")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedCustomString(@QueryParam(value="value") String value) {
        String msg;
        boolean pass = false;
        String customValue = this.customString;
        if (customValue == null || customValue.length() == 0) {
            msg = "customString value is null or empty, FAIL";
        } else if (customValue.equals(value)) {
            msg = "customString PASS";
            pass = true;
        } else {
            msg = String.format("customString: %s != %s", customValue, value);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyInjectedCustomBoolean")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedCustomBoolean(@QueryParam(value="value") String value) {
        String msg;
        boolean pass = false;
        if (this.customBooleanWrapper == null || this.customBoolean != this.customBooleanWrapper) {
            msg = "injected boolean values are different";
        } else if (Boolean.valueOf(value) == this.customBoolean) {
            msg = "customBoolean PASS";
            pass = true;
        } else {
            msg = String.format("customBoolean: %s != %s", this.customBoolean, value);
        }
        return Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
    }
}

