/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.ejb;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.eclipse.microprofile.jwt.tck.container.ejb.IService;

@Stateless
public class ServiceEJB
implements IService {
    @Resource
    private SessionContext ctx;

    @Override
    @RolesAllowed(value={"Echoer"})
    public String echo(String input) {
        Principal user = this.ctx.getCallerPrincipal();
        return String.format("ServiceEJB, input=%s, user=%s", input, user.getName());
    }

    @Override
    @RolesAllowed(value={"Tester"})
    public String getPrincipalClass() {
        Object tmp;
        Principal user = this.ctx.getCallerPrincipal();
        System.out.printf("ServiceEJB.getPrincipalClass, user=%s, class=%s\n", user.getName(), user.getClass());
        HashSet<Object> interfaces = new HashSet<Object>();
        Class<?> current = user.getClass();
        while (!current.equals(Object.class)) {
            for (Object c : tmp = current.getInterfaces()) {
                interfaces.add(c);
            }
            current = current.getSuperclass();
        }
        tmp = new StringBuilder();
        for (Class clazz : interfaces) {
            ((StringBuilder)tmp).append(clazz.getTypeName());
            ((StringBuilder)tmp).append(',');
        }
        ((StringBuilder)tmp).setLength(((StringBuilder)tmp).length() - 1);
        return ((StringBuilder)tmp).toString();
    }

    @Override
    @RolesAllowed(value={"Tester"})
    public String getSubjectClass() throws Exception {
        Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        System.out.printf("ServiceEJB.getSubjectClass, subject=%s\n", subject);
        Set<JsonWebToken> principalSet = subject.getPrincipals(JsonWebToken.class);
        if (principalSet.size() > 0) {
            return "subject.getPrincipals(JsonWebToken.class) ok";
        }
        throw new IllegalStateException("subject.getPrincipals(JsonWebToken.class) == 0");
    }
}

