/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.lsp4e.test.completion.AbstractCompletionTest;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ContextInformationTest
extends AbstractCompletionTest {
    @Override
    @BeforeEach
    public void setUp() {
        this.contentAssistProcessor = new LSContentAssistProcessor();
    }

    @Test
    public void testNoContextInformation() throws CoreException {
        MockLanguageServer.INSTANCE.setSignatureHelp(new SignatureHelp());
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IContextInformation[] infos = this.contentAssistProcessor.computeContextInformation(viewer, 0);
        Assertions.assertEquals((int)0, (int)infos.length);
    }

    @Test
    public void testContextInformationNoParameters() throws CoreException {
        SignatureHelp signatureHelp = new SignatureHelp();
        SignatureInformation information = new SignatureInformation("label", "documentation", Collections.emptyList());
        signatureHelp.setSignatures(List.of(information));
        MockLanguageServer.INSTANCE.setSignatureHelp(signatureHelp);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "method()");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IContextInformation[] infos = this.contentAssistProcessor.computeContextInformation(viewer, 0);
        Assertions.assertEquals((int)1, (int)infos.length);
        String expected = information.getLabel() + '\n' + LSPEclipseUtils.getDocString((Either)information.getDocumentation());
        Assertions.assertEquals((Object)expected, (Object)infos[0].getInformationDisplayString());
    }

    @Test
    public void testTriggerChars() throws CoreException {
        Set<String> triggers = Set.of("a", "b");
        MockLanguageServer.INSTANCE.setContextInformationTriggerChars(triggers);
        String content = "First";
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        Assertions.assertArrayEquals((char[])new char[]{'a', 'b'}, (char[])this.contentAssistProcessor.getContextInformationAutoActivationCharacters());
    }

    @Test
    public void testTriggerCharsNullList() throws CoreException {
        MockLanguageServer.INSTANCE.setContextInformationTriggerChars(null);
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        Assertions.assertArrayEquals((char[])new char[0], (char[])this.contentAssistProcessor.getContextInformationAutoActivationCharacters());
    }
}

