/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.internal;

import java.util.stream.Stream;
import org.eclipse.lsp4e.internal.MarkdownUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MarkdownUtilTest {
    public static Stream<Arguments> renderToHtml() {
        return Stream.of(Arguments.argumentSet((String)"Simple", (Object[])new Object[]{"# Heading 1\n- this is a test", "<h1>Heading 1</h1>\n<ul>\n<li>this is a test</li>\n</ul>\n"}), Arguments.argumentSet((String)"With table", (Object[])new Object[]{"| Header  | Another Header |\n|---------|----------------|\n| field 1 | value one      |", "<table>\n<thead>\n<tr>\n<th>Header</th>\n<th>Another Header</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>field 1</td>\n<td>value one</td>\n</tr>\n</tbody>\n</table>\n"}));
    }

    @ParameterizedTest
    @MethodSource
    void renderToHtml(String markdown, String expectedHtml) throws Exception {
        Assertions.assertEquals((Object)expectedHtml, (Object)MarkdownUtil.renderToHtml((String)markdown));
    }
}

