/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.lsp4e.debug.breakpoints.DSPLineBreakpoint;
import org.eclipse.lsp4e.debug.debugmodel.DSPBreakpointManager;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BreakpointMappingTest
extends AbstractTestWithProject {
    private List<IBreakpoint> created = new ArrayList<IBreakpoint>();

    BreakpointMappingTest() {
    }

    @BeforeEach
    void clearBreakpoints() throws CoreException {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            bp.delete();
            ++n2;
        }
    }

    @AfterEach
    void cleanupCreated() throws CoreException {
        for (IBreakpoint bp : this.created) {
            bp.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void breakpoint_conditions_are_sent_to_server() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "txt", "first line\nsecond line\n");
        DSPLineBreakpoint bp = new DSPLineBreakpoint((IResource)file, 2);
        bp.setCondition("x > 0");
        bp.setColumn(7);
        bp.setHitCondition(">= 3");
        this.created.add((IBreakpoint)bp);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)bp);
        CapturingServer server = new CapturingServer();
        DSPBreakpointManager manager = new DSPBreakpointManager(DebugPlugin.getDefault().getBreakpointManager(), (IDebugProtocolServer)server, null);
        try {
            manager.initialize().join();
            SetBreakpointsArguments matching = null;
            List<SetBreakpointsArguments> list = server.calls;
            synchronized (list) {
                Assertions.assertTrue((!server.calls.isEmpty() ? 1 : 0) != 0, (String)"No setBreakpoints() calls captured");
                String path = file.getLocation().toOSString();
                for (SetBreakpointsArguments a : server.calls) {
                    if (a.getSource() == null || !path.equals(a.getSource().getPath())) continue;
                    matching = a;
                    break;
                }
            }
            Assertions.assertNotNull(matching, (String)"No setBreakpoints() call for our file was captured");
            SourceBreakpoint[] sent = matching.getBreakpoints();
            Assertions.assertNotNull((Object)sent);
            Assertions.assertEquals((int)1, (int)sent.length, (String)"Expected exactly one SourceBreakpoint");
            SourceBreakpoint sb = sent[0];
            Assertions.assertEquals((Object)"x > 0", (Object)sb.getCondition());
            Assertions.assertEquals((int)7, (Integer)sb.getColumn());
            Assertions.assertEquals((Object)">= 3", (Object)sb.getHitCondition());
        }
        finally {
            manager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void changing_breakpoint_condition_replaces_existing_entry() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "txt", "first line\nsecond line\n");
        DSPLineBreakpoint bp = new DSPLineBreakpoint((IResource)file, 2);
        bp.setCondition("x > 0");
        this.created.add((IBreakpoint)bp);
        CapturingServer server = new CapturingServer();
        DSPBreakpointManager manager = new DSPBreakpointManager(DebugPlugin.getDefault().getBreakpointManager(), (IDebugProtocolServer)server, null);
        try {
            manager.initialize().join();
            manager.breakpointAdded((IBreakpoint)bp);
            server.calls.clear();
            bp.setCondition("x > 1");
            manager.breakpointChanged((IBreakpoint)bp, null);
            SetBreakpointsArguments matching = null;
            List<SetBreakpointsArguments> list = server.calls;
            synchronized (list) {
                Assertions.assertTrue((!server.calls.isEmpty() ? 1 : 0) != 0, (String)"No setBreakpoints() calls captured after breakpoint condition change");
                String path = file.getLocation().toOSString();
                for (SetBreakpointsArguments a : server.calls) {
                    if (a.getSource() == null || !path.equals(a.getSource().getPath())) continue;
                    matching = a;
                    break;
                }
            }
            Assertions.assertNotNull(matching, (String)"No setBreakpoints() call for our file was captured after breakpoint condition change");
            SourceBreakpoint[] sent = matching.getBreakpoints();
            Assertions.assertNotNull((Object)sent);
            Assertions.assertEquals((int)1, (int)sent.length, (String)"Expected exactly one SourceBreakpoint after condition change");
            SourceBreakpoint sb = sent[0];
            Assertions.assertEquals((Object)"x > 1", (Object)sb.getCondition());
        }
        finally {
            manager.shutdown();
        }
    }

    private static class CapturingServer
    implements IDebugProtocolServer {
        List<SetBreakpointsArguments> calls = new ArrayList<SetBreakpointsArguments>();

        private CapturingServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments arguments) {
            List<SetBreakpointsArguments> list = this.calls;
            synchronized (list) {
                this.calls.add(arguments);
            }
            SetBreakpointsResponse resp = new SetBreakpointsResponse();
            resp.setBreakpoints(new Breakpoint[0]);
            return CompletableFuture.completedFuture(resp);
        }
    }
}

