/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.NoErrorLoggedRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class LSPEclipseUtilsTest
extends AbstractTestWithProject {
    @RegisterExtension
    public final NoErrorLoggedRule noErrorLoggedRule = new NoErrorLoggedRule();

    @Test
    public void testOpenInEditorExternalFile() throws Exception {
        File externalFile = TestUtils.createTempFile("externalFile", ".txt");
        Location location = new Location(LSPEclipseUtils.toUri((File)externalFile).toString(), new Range(new Position(0, 0), new Position(0, 0)));
        LSPEclipseUtils.openInEditor((Location)location, (IWorkbenchPage)UI.getActivePage());
    }

    @Test
    public void testWorkspaceEdit_insertText() throws Exception {
        TextEdit textEdit = new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "insert");
        AbstractTextEditor editor = this.applyWorkspaceTextEdit(textEdit);
        Assertions.assertEquals((Object)"insertHere", (Object)((StyledText)editor.getAdapter(Control.class)).getText());
        Assertions.assertEquals((Object)"insertHere", (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
    }

    @Test
    public void testWorkspaceEdit_WithExaggeratedRange() throws Exception {
        TextEdit textEdit = new TextEdit(new Range(new Position(0, 0), new Position(Integer.MAX_VALUE, Integer.MAX_VALUE)), "insert");
        AbstractTextEditor editor = this.applyWorkspaceTextEdit(textEdit);
        Assertions.assertEquals((Object)"insert", (Object)((StyledText)editor.getAdapter(Control.class)).getText());
        Assertions.assertEquals((Object)"insert", (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
    }

    private AbstractTextEditor applyWorkspaceTextEdit(TextEdit textEdit) throws CoreException {
        IFile f = TestUtils.createFile(this.project, "dummy" + new Random().nextInt(), "Here");
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonMap(LSPEclipseUtils.toUri((IResource)f).toString(), List.of(textEdit)));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)workspaceEdit);
        return editor;
    }

    @Test
    public void testWorkspaceEditMultipleChanges() throws Exception {
        IFile f = TestUtils.createFile(this.project, "dummy", "Here\nHere2");
        AbstractTextEditor editor = (AbstractTextEditor)TestUtils.openEditor(f);
        LinkedList<TextEdit> edits = new LinkedList<TextEdit>();
        edits.add(new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "abc"));
        edits.add(new TextEdit(new Range(new Position(1, 0), new Position(1, 0)), "abc"));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonMap(LSPEclipseUtils.toUri((IResource)f).toString(), edits));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)workspaceEdit);
        Assertions.assertEquals((Object)"abcHere\nabcHere2", (Object)((StyledText)editor.getAdapter(Control.class)).getText());
        Assertions.assertEquals((Object)"abcHere\nabcHere2", (Object)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get());
    }

    @Test
    public void testWorkspaceEdit_CreateAndPopulateFile() throws Exception {
        IFile file = this.project.getFile("test-file.test");
        LinkedList<Either> edits = new LinkedList<Either>();
        String uri = file.getLocation().toFile().toURI().toString();
        edits.add(Either.forRight((Object)new CreateFile(uri)));
        edits.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), List.of(new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "abcHere\nabcHere2")))));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(edits);
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)workspaceEdit);
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertEquals((Object)"abcHere\nabcHere2", (Object)new String(Files.readAllBytes(file.getLocation().toFile().toPath())));
    }

    @Test
    public void testURIToResourceMapping() throws CoreException {
        IFile file = this.project.getFile("res");
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertEquals((Object)file, (Object)LSPEclipseUtils.findResourceFor((String)file.getLocationURI().toString()));
        this.project.getFile("suffix").create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        IProject project2 = TestUtils.createProject(this.project.getName() + "suffix");
        Assertions.assertEquals((Object)project2, (Object)LSPEclipseUtils.findResourceFor((String)project2.getLocationURI().toString()));
    }

    @Test
    public void testReturnMostNestedFileRegardlessArrayOrder() throws CoreException {
        IFile mostNestedFile = this.project.getFile("res");
        mostNestedFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        IFolder folder = this.project.getFolder("folder");
        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IFile someFile = this.project.getFile("folder/res");
        someFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertEquals((Object)mostNestedFile, (Object)LSPEclipseUtils.findMostNested((IFile[])new IFile[]{mostNestedFile, someFile}));
        Assertions.assertEquals((Object)mostNestedFile, (Object)LSPEclipseUtils.findMostNested((IFile[])new IFile[]{someFile, mostNestedFile}));
    }

    @Test
    public void testLinkedResourceURIToResourceMapping() throws CoreException, IOException {
        java.nio.file.Path externalFile = Files.createTempFile("tmp_file-", null, new FileAttribute[0]);
        java.nio.file.Path externalFolder = Files.createTempDirectory("tmp_dir-", new FileAttribute[0]);
        IFile linkedFile = this.project.getFile("linked_file");
        linkedFile.createLink(externalFile.toUri(), 0, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((boolean)linkedFile.isLinked());
        Assertions.assertEquals((Object)linkedFile, (Object)LSPEclipseUtils.findResourceFor((String)linkedFile.getLocationURI().toString()));
        IFolder linkedFolder = this.project.getFolder("linked_folder");
        linkedFolder.createLink(externalFolder.toUri(), 0, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((boolean)linkedFolder.isLinked());
        Assertions.assertEquals((Object)linkedFolder, (Object)LSPEclipseUtils.findResourceFor((String)linkedFolder.getLocationURI().toString()));
        Files.createFile(externalFolder.resolve("child"), new FileAttribute[0]);
        IFile linkedFolderFile = linkedFolder.getFile("child");
        Assertions.assertEquals((Object)linkedFolderFile, (Object)LSPEclipseUtils.findResourceFor((String)linkedFolderFile.getLocationURI().toString()));
    }

    @Test
    public void testVirtualResourceURIToResourceMapping() throws CoreException, IOException {
        java.nio.file.Path externalFile = Files.createTempFile("tmp_file-", null, new FileAttribute[0]);
        java.nio.file.Path externalFolder = Files.createTempDirectory("tmp_dir-", new FileAttribute[0]);
        IFolder virtualFolder = this.project.getFolder("virtual_folder");
        virtualFolder.create(8192, true, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertEquals((Object)virtualFolder.isVirtual(), (Object)true);
        Assertions.assertEquals((Object)virtualFolder.getLocationURI().toString(), (Object)"virtual:/virtual");
        Assertions.assertEquals((Object)virtualFolder.getRawLocationURI().toString(), (Object)"virtual:/virtual");
        Assertions.assertEquals(null, (Object)LSPEclipseUtils.findResourceFor((String)virtualFolder.getLocationURI().toString()));
        IFile linkedFile = virtualFolder.getFile("linked_file");
        linkedFile.createLink(externalFile.toUri(), 0, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((boolean)linkedFile.isLinked());
        Assertions.assertEquals((Object)linkedFile, (Object)LSPEclipseUtils.findResourceFor((String)linkedFile.getLocationURI().toString()));
        IFolder linkedFolder = virtualFolder.getFolder("linked_folder");
        linkedFolder.createLink(externalFolder.toUri(), 0, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((boolean)linkedFolder.isLinked());
        Assertions.assertEquals((Object)linkedFolder, (Object)LSPEclipseUtils.findResourceFor((String)linkedFolder.getLocationURI().toString()));
        Files.createFile(externalFolder.resolve("child"), new FileAttribute[0]);
        IFile linkedFolderFile = linkedFolder.getFile("child");
        Assertions.assertEquals((Object)linkedFolderFile, (Object)LSPEclipseUtils.findResourceFor((String)linkedFolderFile.getLocationURI().toString()));
    }

    @Test
    public void testCustomURIToResourceMapping() throws CoreException {
        URI uri = URI.create("other://a/res.txt");
        this.project = TestUtils.createProject(LSPEclipseUtilsTest.class.getSimpleName() + uri.getScheme());
        IFile file = this.project.getFile("res.txt");
        file.createLink(uri, 272, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertEquals((Object)file, (Object)LSPEclipseUtils.findResourceFor((String)file.getLocationURI().toString()));
        Assertions.assertEquals((Object)file, (Object)LSPEclipseUtils.getFileHandle((URI)file.getLocationURI()));
    }

    @Test
    public void testCustomResourceToURIMapping() throws CoreException {
        URI uri = URI.create("other://res.txt");
        IFile file = this.project.getFile("res.txt");
        file.createLink(uri, 272, (IProgressMonitor)new NullProgressMonitor());
        Assertions.assertEquals((Object)LSPEclipseUtils.toUri((IResource)file).toString(), (Object)"other://a/res.txt");
    }

    @Test
    public void testApplyTextEditLongerThanOrigin() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "line1\nlineInsertHere");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        TextEdit textEdit = new TextEdit(new Range(new Position(1, 4), new Position(1, 4 + "InsertHere".length())), "Inserted");
        IDocument document = viewer.getDocument();
        LSPEclipseUtils.applyEdit((TextEdit)textEdit, (IDocument)document);
        Assertions.assertEquals((Object)"line1\nlineInserted", (Object)document.get());
    }

    @Test
    public void testApplyTextEditShorterThanOrigin() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "line1\nlineHERE");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        TextEdit textEdit = new TextEdit(new Range(new Position(1, 4), new Position(1, 4 + "HERE".length())), "Inserted");
        IDocument document = viewer.getDocument();
        LSPEclipseUtils.applyEdit((TextEdit)textEdit, (IDocument)document);
        Assertions.assertEquals((Object)"line1\nlineInserted", (Object)document.get());
    }

    @Test
    public void testTextEditInsertSameOffset() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        TextEdit[] edits = new TextEdit[]{new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), " throws "), new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "Exception")};
        IDocument document = viewer.getDocument();
        LSPEclipseUtils.applyEdits((IDocument)document, List.of(edits));
        Assertions.assertEquals((Object)" throws Exception", (Object)document.get());
    }

    @Test
    public void testTextEditSplittedLineEndings() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "line1\r\nline2\r\nline3\r\n");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        TextEdit[] edits = new TextEdit[]{new TextEdit(new Range(new Position(0, 0), new Position(2, 6)), "line3\r\nline2\r\nline1\r")};
        IDocument document = viewer.getDocument();
        int linesBeforeApplyEdits = document.getNumberOfLines();
        LSPEclipseUtils.applyEdits((IDocument)document, List.of(edits));
        Assertions.assertEquals((Object)"line3\r\nline2\r\nline1\r\n", (Object)document.get());
        Assertions.assertEquals((int)linesBeforeApplyEdits, (int)document.getNumberOfLines());
    }

    @Test
    public void testURICreationUnix() {
        Assumptions.assumeFalse((boolean)"win32".equals(Platform.getOS()));
        Assertions.assertEquals((Object)"file:///test%20with%20space", (Object)LSPEclipseUtils.toUri((File)new File("/test with space")).toString());
    }

    @Test
    public void testToUri_WindowsDriveLetter() {
        Assumptions.assumeTrue((boolean)"win32".equals(Platform.getOS()));
        File drivePath = new File("C:\\Temp\\with space");
        URI uri = LSPEclipseUtils.toUri((File)drivePath);
        Assertions.assertTrue((boolean)uri.toString().startsWith("file:///C:/Temp/"));
        Assertions.assertFalse((boolean)uri.toString().contains("  "));
        Assertions.assertTrue((boolean)uri.toString().contains("with%20space"));
        Assertions.assertFalse((boolean)uri.toString().startsWith("file:////"));
    }

    @Test
    public void testUNCwindowsURI() {
        Assumptions.assumeTrue((boolean)"win32".equals(Platform.getOS()));
        URI preferredURI = URI.create("file://localhost/c$/Windows");
        URI javaURI = URI.create("file:////localhost/c$/Windows");
        File file1 = LSPEclipseUtils.fromUri((URI)preferredURI);
        File file2 = LSPEclipseUtils.fromUri((URI)javaURI);
        Assertions.assertEquals((Object)file1, (Object)file2);
    }

    @Test
    public void testToUri_WindowsUNC() {
        Assumptions.assumeTrue((boolean)"win32".equals(Platform.getOS()));
        File unc = new File("\\\\localhost\\c$\\Windows");
        URI uri = LSPEclipseUtils.toUri((File)unc);
        System.err.println(uri.toString());
        Assertions.assertTrue((boolean)uri.toString().startsWith("file://localhost/c$/Windows"));
        File uncWithSpaces = new File("\\\\server-name\\shared folder\\dir with space");
        URI uriWithSpaces = LSPEclipseUtils.toUri((File)uncWithSpaces);
        Assertions.assertTrue((boolean)uriWithSpaces.toString().startsWith("file://server-name/shared%20folder/dir%20with%20space"));
        Assertions.assertFalse((boolean)uriWithSpaces.toString().startsWith("file:////"));
    }

    @Test
    public void testToWorkspaceFolder() {
        WorkspaceFolder folder = LSPEclipseUtils.toWorkspaceFolder((IProject)this.project);
        Assertions.assertEquals((Object)this.project.getName(), (Object)folder.getName());
        Assertions.assertEquals((Object)"file://", (Object)folder.getUri().substring(0, "file://".length()));
    }

    @Test
    public void testResourceOperations() throws Exception {
        IFile targetFile = this.project.getFile("some/folder/file.txt");
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)new WorkspaceEdit(List.of(Either.forRight((Object)new CreateFile(targetFile.getLocationURI().toString())))));
        Assertions.assertTrue((boolean)targetFile.exists());
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)new WorkspaceEdit(List.of(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(targetFile.getLocationURI().toString(), Integer.valueOf(1)), List.of(new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), "hello")))))));
        Assertions.assertEquals((Object)"hello", (Object)this.readContent(targetFile));
        IFile otherFile = this.project.getFile("another/folder/file.lol");
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)new WorkspaceEdit(List.of(Either.forRight((Object)new RenameFile(targetFile.getLocationURI().toString(), otherFile.getLocationURI().toString())))));
        Assertions.assertFalse((boolean)targetFile.exists());
        Assertions.assertTrue((boolean)otherFile.exists());
        Assertions.assertEquals((Object)"hello", (Object)this.readContent(otherFile));
    }

    @Test
    public void createExternalFile() throws Exception {
        File file = TestUtils.createTempFile(String.valueOf(this.getClass()) + "editExternalFile", ".whatever");
        file.delete();
        Assertions.assertFalse((boolean)file.exists());
        WorkspaceEdit we = new WorkspaceEdit(List.of(Either.forRight((Object)new CreateFile(file.toURI().toString()))));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assertions.assertTrue((boolean)file.isFile());
    }

    @Test
    public void editExternalFile() throws Exception {
        File file = TestUtils.createTempFile(String.valueOf(this.getClass()) + "editExternalFile", ".whatever");
        TextEdit te = new TextEdit();
        te.setRange(new Range(new Position(0, 0), new Position(0, 0)));
        te.setNewText("abc\ndef");
        TextDocumentEdit docEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(file.toURI().toString(), null), List.of(te));
        WorkspaceEdit we = new WorkspaceEdit(List.of(Either.forLeft((Object)docEdit)));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assertions.assertTrue((boolean)file.isFile());
        Assertions.assertEquals((Object)"abc\ndef", (Object)new String(Files.readAllBytes(file.toPath())));
    }

    @Test
    public void renameExternalFile() throws Exception {
        File oldFile = TestUtils.createTempFile(String.valueOf(this.getClass()) + "editExternalFile", ".whatever");
        File newFile = new File(oldFile.getAbsolutePath() + "_renamed");
        TestUtils.addManagedTempFile(newFile);
        WorkspaceEdit we = new WorkspaceEdit(List.of(Either.forRight((Object)new RenameFile(oldFile.toURI().toString(), newFile.toURI().toString()))));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assertions.assertFalse((boolean)oldFile.isFile());
        Assertions.assertTrue((boolean)newFile.isFile());
    }

    /*
     * Loose catch block
     */
    private String readContent(IFile targetFile) throws IOException, CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            String string;
            InputStream contentStream;
            ByteArrayOutputStream stream;
            block16: {
                block15: {
                    stream = new ByteArrayOutputStream((int)targetFile.getLocation().toFile().length());
                    contentStream = targetFile.getContents();
                    contentStream.transferTo(stream);
                    string = new String(stream.toByteArray());
                    if (contentStream == null) break block15;
                    contentStream.close();
                }
                if (stream == null) break block16;
                stream.close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (contentStream != null) {
                            contentStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (stream != null) {
                            stream.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void testTextEditDoesntAutomaticallySaveOpenResourceFiles() throws Exception {
        IFile targetFile = this.project.getFile("blah.txt");
        targetFile.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)UI.getActivePage(), (IFile)targetFile, (String)"org.eclipse.ui.genericeditor.GenericEditor");
        TextEdit te = new TextEdit();
        te.setRange(new Range(new Position(0, 0), new Position(0, 0)));
        te.setNewText("abc\ndef");
        TextDocumentEdit docEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(LSPEclipseUtils.toUri((IResource)targetFile).toString(), null), List.of(te));
        WorkspaceEdit we = new WorkspaceEdit(List.of(Either.forLeft((Object)docEdit)));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assertions.assertEquals((Object)"abc\ndef", (Object)((StyledText)((AbstractTextEditor)editor).getAdapter(Control.class)).getText());
        Assertions.assertTrue((boolean)editor.isDirty());
    }

    @Test
    public void testTextEditDoesntAutomaticallySaveOpenExternalFiles() throws Exception {
        File file = TestUtils.createTempFile("testTextEditDoesntAutomaticallySaveOpenExternalFiles", ".whatever");
        IEditorPart editor = IDE.openInternalEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        TextEdit te = new TextEdit();
        te.setRange(new Range(new Position(0, 0), new Position(0, 0)));
        te.setNewText("abc\ndef");
        TextDocumentEdit docEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(file.toURI().toString(), null), List.of(te));
        WorkspaceEdit we = new WorkspaceEdit(List.of(Either.forLeft((Object)docEdit)));
        LSPEclipseUtils.applyWorkspaceEdit((WorkspaceEdit)we);
        Assertions.assertEquals((Object)"abc\ndef", (Object)((StyledText)((AbstractTextEditor)editor).getAdapter(Control.class)).getText());
        Assertions.assertTrue((boolean)editor.isDirty());
    }

    private IPath generateNonExistingIPath(String directory, String fileExtension) {
        java.nio.file.Path path;
        if (((String)directory).startsWith("/")) {
            java.nio.file.Path rootDir = FileSystems.getDefault().getRootDirectories().iterator().next();
            directory = String.valueOf(rootDir) + ((String)directory).substring(1);
        }
        while ((path = Paths.get((String)directory, String.valueOf(UUID.randomUUID()) + "." + fileExtension)).toFile().exists()) {
        }
        return Path.fromOSString((String)path.toString());
    }

    @Test
    public void testGetFile() throws Exception {
        IPath path = Path.fromPortableString((String)"non-existing-file.txt");
        Assertions.assertNull((Object)LSPEclipseUtils.getFile((IPath)path));
        path = Path.fromPortableString((String)"non-existing-folder/non-existing-file.txt");
        Assertions.assertNull((Object)LSPEclipseUtils.getFile((IPath)path));
        path = TestUtils.createFile(this.project, "testGetFile", "txt").getFullPath();
        Assertions.assertNotNull((Object)LSPEclipseUtils.getFile((IPath)path));
        path = this.generateNonExistingIPath("/", "txt");
        Assertions.assertNull((Object)LSPEclipseUtils.getFile((IPath)path));
        path = this.generateNonExistingIPath("/folder", "txt");
        Assertions.assertNull((Object)LSPEclipseUtils.getFile((IPath)path));
        path = Path.fromOSString((String)TestUtils.createTempFile("testGetFile", ".txt").getAbsolutePath());
        Assertions.assertNull((Object)LSPEclipseUtils.getFile((IPath)path));
    }

    @Test
    public void testGetOpenEditorExternalFile() throws Exception {
        File file = TestUtils.createTempFile("testDiagnosticsOnExternalFile", ".lspt");
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(97);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        Assertions.assertNotEquals(Collections.emptySet(), (Object)LSPEclipseUtils.findOpenEditorsFor((URI)file.toURI()));
    }

    @Test
    public void testToCompletionParams_EmptyDocument() throws Exception {
        IFile file = TestUtils.createFile(this.project, "dummy" + new Random().nextInt(), "");
        char[] triggerChars = new char[]{':', '>'};
        CompletionParams param = LSPEclipseUtils.toCompletionParams((URI)file.getLocationURI(), (int)0, (IDocument)LSPEclipseUtils.getDocument((IResource)file), (char[])triggerChars);
        Assertions.assertNull((Object)param.getContext());
    }

    @Test
    public void testToCompletionParams_ZeroOffset() throws Exception {
        IFile file = TestUtils.createFile(this.project, "dummy" + new Random().nextInt(), "std");
        char[] triggerChars = new char[]{':', '>'};
        CompletionParams param = LSPEclipseUtils.toCompletionParams((URI)file.getLocationURI(), (int)0, (IDocument)LSPEclipseUtils.getDocument((IResource)file), (char[])triggerChars);
        Assertions.assertEquals((Object)param.getContext().getTriggerKind(), (Object)CompletionTriggerKind.Invoked);
    }

    @Test
    public void testToCompletionParams_MatchingTriggerCharacter() throws Exception {
        IFile file = TestUtils.createFile(this.project, "dummy" + new Random().nextInt(), "std:");
        char[] triggerChars = new char[]{':', '>'};
        CompletionParams param = LSPEclipseUtils.toCompletionParams((URI)file.getLocationURI(), (int)4, (IDocument)LSPEclipseUtils.getDocument((IResource)file), (char[])triggerChars);
        Assertions.assertEquals((Object)param.getContext().getTriggerCharacter(), (Object)":");
        Assertions.assertEquals((Object)param.getContext().getTriggerKind(), (Object)CompletionTriggerKind.TriggerCharacter);
    }

    @Test
    public void testToCompletionParams_NonMatchingTriggerCharacter() throws Exception {
        IFile file = TestUtils.createFile(this.project, "dummy" + new Random().nextInt(), "std");
        char[] triggerChars = new char[]{':', '>'};
        CompletionParams param = LSPEclipseUtils.toCompletionParams((URI)file.getLocationURI(), (int)3, (IDocument)LSPEclipseUtils.getDocument((IResource)file), (char[])triggerChars);
        Assertions.assertEquals((Object)param.getContext().getTriggerKind(), (Object)CompletionTriggerKind.Invoked);
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineNo() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35");
        Assertions.assertEquals((int)34, (int)actual.getStart().getLine());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineNoEndLineNo() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35-L36");
        Assertions.assertEquals((int)34, (int)actual.getStart().getLine());
        Assertions.assertEquals((int)35, (int)actual.getEnd().getLine());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineStartCharNoEndLineNo() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35,10");
        Assertions.assertEquals((int)34, (int)actual.getStart().getLine());
        Assertions.assertEquals((int)9, (int)actual.getStart().getCharacter());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineStartCharWithEndLineNo() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35,10-L37");
        Assertions.assertEquals((int)34, (int)actual.getStart().getLine());
        Assertions.assertEquals((int)9, (int)actual.getStart().getCharacter());
        Assertions.assertEquals((int)36, (int)actual.getEnd().getLine());
        Assertions.assertEquals((int)9, (int)actual.getEnd().getCharacter());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithStartLineStartCharWithEndLineNoWithEndChar() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#L35,10-L37,34");
        Assertions.assertEquals((int)34, (int)actual.getStart().getLine());
        Assertions.assertEquals((int)9, (int)actual.getStart().getCharacter());
        Assertions.assertEquals((int)36, (int)actual.getEnd().getLine());
        Assertions.assertEquals((int)33, (int)actual.getEnd().getCharacter());
    }

    @Test
    public void parseRange_shouldReturnRange_UriWithoutLCharacter() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#35,10-37,34");
        Assertions.assertEquals((int)34, (int)actual.getStart().getLine());
        Assertions.assertEquals((int)9, (int)actual.getStart().getCharacter());
        Assertions.assertEquals((int)36, (int)actual.getEnd().getLine());
        Assertions.assertEquals((int)33, (int)actual.getEnd().getCharacter());
    }

    @Test
    public void parseRange_shouldReturnNullRange_BlankFragment() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b#");
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void parseRange_shouldReturnNullRange_NoFragment() {
        Range actual = LSPEclipseUtils.parseRange((String)"file:///a/b");
        Assertions.assertNull((Object)actual);
    }
}

