/**
 */
package distributions.impl;

import distributions.DistributionsPackage;
import distributions.GammaDistribution;

import distributions.math.ModeDistribution;

import expressions.Expression;

import expressions.impl.ExpressionImpl;

import java.lang.reflect.InvocationTargetException;

import java.math.BigDecimal;

import org.apache.commons.math3.random.RandomGenerator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Gamma Distribution</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link distributions.impl.GammaDistributionImpl#getDefault <em>Default</em>}</li>
 *   <li>{@link distributions.impl.GammaDistributionImpl#getDefaultExp <em>Default Exp</em>}</li>
 *   <li>{@link distributions.impl.GammaDistributionImpl#getModeDistributionInstance <em>Mode Distribution Instance</em>}</li>
 *   <li>{@link distributions.impl.GammaDistributionImpl#getShape <em>Shape</em>}</li>
 *   <li>{@link distributions.impl.GammaDistributionImpl#getScale <em>Scale</em>}</li>
 *   <li>{@link distributions.impl.GammaDistributionImpl#getInverseCumAccuracy <em>Inverse Cum Accuracy</em>}</li>
 *   <li>{@link distributions.impl.GammaDistributionImpl#getShapeExp <em>Shape Exp</em>}</li>
 *   <li>{@link distributions.impl.GammaDistributionImpl#getScaleExp <em>Scale Exp</em>}</li>
 *   <li>{@link distributions.impl.GammaDistributionImpl#getInverseCumAccuracyExp <em>Inverse Cum Accuracy Exp</em>}</li>
 * </ul>
 *
 * @generated
 */
public class GammaDistributionImpl extends ExpressionImpl implements GammaDistribution
{
    /**
     * The default value of the '{@link #getDefault() <em>Default</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefault()
     * @generated
     * @ordered
     */
    protected static final BigDecimal DEFAULT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDefaultExp() <em>Default Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDefaultExp()
     * @generated
     * @ordered
     */
    protected Expression defaultExp;

    /**
     * The default value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected static final ModeDistribution MODE_DISTRIBUTION_INSTANCE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getModeDistributionInstance() <em>Mode Distribution Instance</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getModeDistributionInstance()
     * @generated
     * @ordered
     */
    protected ModeDistribution modeDistributionInstance = MODE_DISTRIBUTION_INSTANCE_EDEFAULT;

    /**
     * The default value of the '{@link #getShape() <em>Shape</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getShape()
     * @generated
     * @ordered
     */
    protected static final BigDecimal SHAPE_EDEFAULT = null;

    /**
     * The default value of the '{@link #getScale() <em>Scale</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getScale()
     * @generated
     * @ordered
     */
    protected static final BigDecimal SCALE_EDEFAULT = null;

    /**
     * The default value of the '{@link #getInverseCumAccuracy() <em>Inverse Cum Accuracy</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getInverseCumAccuracy()
     * @generated
     * @ordered
     */
    protected static final BigDecimal INVERSE_CUM_ACCURACY_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getShapeExp() <em>Shape Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getShapeExp()
     * @generated
     * @ordered
     */
    protected Expression shapeExp;

    /**
     * The cached value of the '{@link #getScaleExp() <em>Scale Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getScaleExp()
     * @generated
     * @ordered
     */
    protected Expression scaleExp;

    /**
     * The cached value of the '{@link #getInverseCumAccuracyExp() <em>Inverse Cum Accuracy Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getInverseCumAccuracyExp()
     * @generated
     * @ordered
     */
    protected Expression inverseCumAccuracyExp;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GammaDistributionImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return DistributionsPackage.Literals.GAMMA_DISTRIBUTION;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getDefault()
    {
        return defaultExp==null ? null:  defaultExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getDefaultExp()
    {
        return defaultExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetDefaultExp(Expression newDefaultExp, NotificationChain msgs)
    {
        Expression oldDefaultExp = defaultExp;
        defaultExp = newDefaultExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT_EXP, oldDefaultExp, newDefaultExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setDefaultExp(Expression newDefaultExp)
    {
        if (newDefaultExp != defaultExp)
        {
            NotificationChain msgs = null;
            if (defaultExp != null)
                msgs = ((InternalEObject)defaultExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            if (newDefaultExp != null)
                msgs = ((InternalEObject)newDefaultExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT_EXP, null, msgs);
            msgs = basicSetDefaultExp(newDefaultExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT_EXP, newDefaultExp, newDefaultExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistributionInstance()
    {
        return modeDistributionInstance;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setModeDistributionInstance(ModeDistribution newModeDistributionInstance)
    {
        ModeDistribution oldModeDistributionInstance = modeDistributionInstance;
        modeDistributionInstance = newModeDistributionInstance;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.GAMMA_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE, oldModeDistributionInstance, modeDistributionInstance));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getShape()
    {
        return shapeExp==null ? null:  shapeExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getScale()
    {
        return scaleExp==null ? null:  scaleExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal getInverseCumAccuracy()
    {
        return inverseCumAccuracyExp==null ? BigDecimal.valueOf(org.apache.commons.math3.distribution.GammaDistribution.DEFAULT_INVERSE_ABSOLUTE_ACCURACY):  inverseCumAccuracyExp.evaluate();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getShapeExp()
    {
        return shapeExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetShapeExp(Expression newShapeExp, NotificationChain msgs)
    {
        Expression oldShapeExp = shapeExp;
        shapeExp = newShapeExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE_EXP, oldShapeExp, newShapeExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setShapeExp(Expression newShapeExp)
    {
        if (newShapeExp != shapeExp)
        {
            NotificationChain msgs = null;
            if (shapeExp != null)
                msgs = ((InternalEObject)shapeExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE_EXP, null, msgs);
            if (newShapeExp != null)
                msgs = ((InternalEObject)newShapeExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE_EXP, null, msgs);
            msgs = basicSetShapeExp(newShapeExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE_EXP, newShapeExp, newShapeExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getScaleExp()
    {
        return scaleExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetScaleExp(Expression newScaleExp, NotificationChain msgs)
    {
        Expression oldScaleExp = scaleExp;
        scaleExp = newScaleExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.GAMMA_DISTRIBUTION__SCALE_EXP, oldScaleExp, newScaleExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setScaleExp(Expression newScaleExp)
    {
        if (newScaleExp != scaleExp)
        {
            NotificationChain msgs = null;
            if (scaleExp != null)
                msgs = ((InternalEObject)scaleExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.GAMMA_DISTRIBUTION__SCALE_EXP, null, msgs);
            if (newScaleExp != null)
                msgs = ((InternalEObject)newScaleExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.GAMMA_DISTRIBUTION__SCALE_EXP, null, msgs);
            msgs = basicSetScaleExp(newScaleExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.GAMMA_DISTRIBUTION__SCALE_EXP, newScaleExp, newScaleExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getInverseCumAccuracyExp()
    {
        return inverseCumAccuracyExp;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetInverseCumAccuracyExp(Expression newInverseCumAccuracyExp, NotificationChain msgs)
    {
        Expression oldInverseCumAccuracyExp = inverseCumAccuracyExp;
        inverseCumAccuracyExp = newInverseCumAccuracyExp;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP, oldInverseCumAccuracyExp, newInverseCumAccuracyExp);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setInverseCumAccuracyExp(Expression newInverseCumAccuracyExp)
    {
        if (newInverseCumAccuracyExp != inverseCumAccuracyExp)
        {
            NotificationChain msgs = null;
            if (inverseCumAccuracyExp != null)
                msgs = ((InternalEObject)inverseCumAccuracyExp).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP, null, msgs);
            if (newInverseCumAccuracyExp != null)
                msgs = ((InternalEObject)newInverseCumAccuracyExp).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP, null, msgs);
            msgs = basicSetInverseCumAccuracyExp(newInverseCumAccuracyExp, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP, newInverseCumAccuracyExp, newInverseCumAccuracyExp));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution createModeDistribution(final RandomGenerator generator)
    {
        return new distributions.math.GammaModeDistribution(generator, 
            getShape().doubleValue(), 
            getScale().doubleValue(), 
            getInverseCumAccuracy().doubleValue(), 
            null == getDefault() ? null : getDefault().doubleValue()
        );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal evaluate()
    {
        var adapter =  distributions.DistributionsAdapter.getAdapter(this);
        var mode = adapter.getCalculationMode();
        if( mode == distributions.CalculationMode.DISTRIBUTED ){
            if( adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on Distributions");
            }
            return BigDecimal.valueOf(getModeDistribution().nextSample());
        }
        return BigDecimal.valueOf(getModeDistribution().getDefault());
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ModeDistribution getModeDistribution()
    {
        if( modeDistributionInstance == null){
            var adapter = distributions.DistributionsAdapter.getAdapter(this);
            if( adapter.getCalculationMode()==distributions.CalculationMode.DISTRIBUTED && adapter.getRandomGenerator() == null ){
                throw new IllegalArgumentException("To use CalculationMode.DISTRIBUTED you'll have to set a RandomGenerator on DistributionsAdapter");
            }
            setModeDistributionInstance( createModeDistribution(adapter.getRandomGenerator()) );
        }
        return modeDistributionInstance;
        
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT_EXP:
                return basicSetDefaultExp(null, msgs);
            case DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE_EXP:
                return basicSetShapeExp(null, msgs);
            case DistributionsPackage.GAMMA_DISTRIBUTION__SCALE_EXP:
                return basicSetScaleExp(null, msgs);
            case DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP:
                return basicSetInverseCumAccuracyExp(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT:
                return getDefault();
            case DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT_EXP:
                return getDefaultExp();
            case DistributionsPackage.GAMMA_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return getModeDistributionInstance();
            case DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE:
                return getShape();
            case DistributionsPackage.GAMMA_DISTRIBUTION__SCALE:
                return getScale();
            case DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY:
                return getInverseCumAccuracy();
            case DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE_EXP:
                return getShapeExp();
            case DistributionsPackage.GAMMA_DISTRIBUTION__SCALE_EXP:
                return getScaleExp();
            case DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP:
                return getInverseCumAccuracyExp();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)newValue);
                return;
            case DistributionsPackage.GAMMA_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance((ModeDistribution)newValue);
                return;
            case DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE_EXP:
                setShapeExp((Expression)newValue);
                return;
            case DistributionsPackage.GAMMA_DISTRIBUTION__SCALE_EXP:
                setScaleExp((Expression)newValue);
                return;
            case DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP:
                setInverseCumAccuracyExp((Expression)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT_EXP:
                setDefaultExp((Expression)null);
                return;
            case DistributionsPackage.GAMMA_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                setModeDistributionInstance(MODE_DISTRIBUTION_INSTANCE_EDEFAULT);
                return;
            case DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE_EXP:
                setShapeExp((Expression)null);
                return;
            case DistributionsPackage.GAMMA_DISTRIBUTION__SCALE_EXP:
                setScaleExp((Expression)null);
                return;
            case DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP:
                setInverseCumAccuracyExp((Expression)null);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT:
                return DEFAULT_EDEFAULT == null ? getDefault() != null : !DEFAULT_EDEFAULT.equals(getDefault());
            case DistributionsPackage.GAMMA_DISTRIBUTION__DEFAULT_EXP:
                return defaultExp != null;
            case DistributionsPackage.GAMMA_DISTRIBUTION__MODE_DISTRIBUTION_INSTANCE:
                return MODE_DISTRIBUTION_INSTANCE_EDEFAULT == null ? modeDistributionInstance != null : !MODE_DISTRIBUTION_INSTANCE_EDEFAULT.equals(modeDistributionInstance);
            case DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE:
                return SHAPE_EDEFAULT == null ? getShape() != null : !SHAPE_EDEFAULT.equals(getShape());
            case DistributionsPackage.GAMMA_DISTRIBUTION__SCALE:
                return SCALE_EDEFAULT == null ? getScale() != null : !SCALE_EDEFAULT.equals(getScale());
            case DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY:
                return INVERSE_CUM_ACCURACY_EDEFAULT == null ? getInverseCumAccuracy() != null : !INVERSE_CUM_ACCURACY_EDEFAULT.equals(getInverseCumAccuracy());
            case DistributionsPackage.GAMMA_DISTRIBUTION__SHAPE_EXP:
                return shapeExp != null;
            case DistributionsPackage.GAMMA_DISTRIBUTION__SCALE_EXP:
                return scaleExp != null;
            case DistributionsPackage.GAMMA_DISTRIBUTION__INVERSE_CUM_ACCURACY_EXP:
                return inverseCumAccuracyExp != null;
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
    {
        switch (operationID)
        {
            case DistributionsPackage.GAMMA_DISTRIBUTION___CREATE_MODE_DISTRIBUTION__RANDOMGENERATOR:
                return createModeDistribution((RandomGenerator)arguments.get(0));
            case DistributionsPackage.GAMMA_DISTRIBUTION___EVALUATE:
                return evaluate();
            case DistributionsPackage.GAMMA_DISTRIBUTION___GET_MODE_DISTRIBUTION:
                return getModeDistribution();
        }
        return super.eInvoke(operationID, arguments);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (modeDistributionInstance: ");
        result.append(modeDistributionInstance);
        result.append(')');
        return result.toString();
    }

} //GammaDistributionImpl
