/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking.generator;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionDouble;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionInt;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTGraph;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTVertex;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGDoubleImplJGraphT;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGIntImplJGraphT;

public class Sprand {
    private Sprand() {
    }

    public static RGDoubleImplJGraphT generateRatioGame(Integer numberOfVertices, Integer edgeRatio, Double maxWeight1, Double maxWeight2) {
        Random rand = new Random();
        Integer max1 = (int)Math.round(maxWeight1);
        Integer max2 = (int)Math.round(maxWeight2);
        BigInteger numberOfEdges = BigInteger.valueOf(numberOfVertices.intValue()).multiply(BigInteger.valueOf(edgeRatio.intValue()));
        JGraphTGraph graph = new JGraphTGraph();
        DoubleWeightFunctionDouble<JGraphTEdge> weights = new DoubleWeightFunctionDouble<JGraphTEdge>();
        ArrayList<JGraphTVertex> vertexList = new ArrayList<JGraphTVertex>();
        int i = 0;
        while (i < numberOfVertices) {
            JGraphTVertex v = new JGraphTVertex(i);
            boolean addToV0 = rand.nextBoolean();
            if (addToV0) {
                graph.addToV0(v);
            } else {
                graph.addToV1(v);
            }
            vertexList.add(v);
            ++i;
        }
        i = 0;
        while (i < vertexList.size()) {
            JGraphTEdge edge = graph.addEdge((JGraphTVertex)vertexList.get(i), (JGraphTVertex)vertexList.get((i + 1) % numberOfVertices));
            Double weight1 = 1.0;
            Double weight2 = 1.0;
            weights.addWeight(edge, weight1, weight2);
            ++i;
        }
        BigInteger v = BigInteger.valueOf(numberOfVertices.intValue());
        BigInteger hamiltonEdges = v.min(BigInteger.ONE);
        BigInteger maximalNumberOfEdges = v.multiply(hamiltonEdges);
        BigInteger possible = maximalNumberOfEdges.subtract(hamiltonEdges);
        BigInteger allowed = numberOfEdges.subtract(hamiltonEdges);
        BigInteger numberOfRandomEdges = possible.min(allowed);
        BigInteger randomToAdd = numberOfRandomEdges = numberOfRandomEdges.max(BigInteger.ZERO);
        while (randomToAdd.compareTo(BigInteger.ZERO) > 0) {
            Integer sourceId = rand.nextInt(vertexList.size() - 1);
            Integer targetId = rand.nextInt(vertexList.size() - 1);
            JGraphTEdge edge = graph.addEdge((JGraphTVertex)vertexList.get(sourceId), (JGraphTVertex)vertexList.get(targetId));
            Double weight1 = 1.0 + ((double)max1.intValue() - 1.0) * rand.nextDouble();
            Double weight2 = 1.0 + ((double)max2.intValue() - 1.0) * rand.nextDouble();
            weights.addWeight(edge, weight1, weight2);
            randomToAdd = randomToAdd.subtract(BigInteger.ONE);
        }
        return new RGDoubleImplJGraphT(graph, weights);
    }

    public static RGIntImplJGraphT generateRatioGame(Integer numberOfVertices, Integer edgeRatio, Integer maxWeight1, Integer maxWeight2) {
        Random rand = new Random();
        BigInteger numberOfEdges = BigInteger.valueOf(numberOfVertices.intValue()).multiply(BigInteger.valueOf(edgeRatio.intValue()));
        JGraphTGraph graph = new JGraphTGraph();
        DoubleWeightFunctionInt<JGraphTEdge> weights = new DoubleWeightFunctionInt<JGraphTEdge>();
        ArrayList<JGraphTVertex> vertexList = new ArrayList<JGraphTVertex>();
        int i = 0;
        while (i < numberOfVertices) {
            JGraphTVertex v = new JGraphTVertex(i);
            boolean addToV0 = rand.nextBoolean();
            if (addToV0) {
                graph.addToV0(v);
            } else {
                graph.addToV1(v);
            }
            vertexList.add(v);
            ++i;
        }
        i = 0;
        while (i < vertexList.size()) {
            JGraphTEdge edge = graph.addEdge((JGraphTVertex)vertexList.get(i), (JGraphTVertex)vertexList.get((i + 1) % numberOfVertices));
            Integer weight1 = 1;
            Integer weight2 = 1;
            weights.addWeight(edge, weight1, weight2);
            ++i;
        }
        BigInteger v = BigInteger.valueOf(numberOfVertices.intValue());
        BigInteger hamiltonEdges = v.min(BigInteger.ONE);
        BigInteger maximalNumberOfEdges = v.multiply(hamiltonEdges);
        BigInteger possible = maximalNumberOfEdges.subtract(hamiltonEdges);
        BigInteger allowed = numberOfEdges.subtract(hamiltonEdges);
        BigInteger numberOfRandomEdges = possible.min(allowed);
        BigInteger randomToAdd = numberOfRandomEdges = numberOfRandomEdges.max(BigInteger.ZERO);
        while (randomToAdd.compareTo(BigInteger.ZERO) > 0) {
            Integer sourceId = rand.nextInt(vertexList.size() - 1);
            Integer targetId = rand.nextInt(vertexList.size() - 1);
            JGraphTEdge edge = graph.addEdge((JGraphTVertex)vertexList.get(sourceId), (JGraphTVertex)vertexList.get(targetId));
            Integer weight1 = rand.nextInt(maxWeight1 - 1) + 1;
            Integer weight2 = rand.nextInt(maxWeight2 - 1) + 1;
            weights.addWeight(edge, weight1, weight2);
            randomToAdd = randomToAdd.subtract(BigInteger.ONE);
        }
        return new RGIntImplJGraphT(graph, weights);
    }
}

