/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algorithms;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.algorithms.CycleFoundException;
import org.eclipse.lsat.common.ludus.backend.graph.Graph;

public final class CycleCheck {
    private CycleCheck() {
    }

    public static <V, E> boolean check(Graph<V, E> graph) {
        HashSet<V> unmarked = new HashSet<V>(graph.getVertices());
        HashSet tempMarked = new HashSet();
        try {
            while (!unmarked.isEmpty()) {
                Object v = unmarked.iterator().next();
                CycleCheck.visit(graph, unmarked, tempMarked, v);
            }
            return false;
        }
        catch (CycleFoundException e) {
            return true;
        }
    }

    private static <V, E> void visit(Graph<V, E> graph, Set<V> unmarked, Set<V> tempMarked, V v) throws CycleFoundException {
        if (tempMarked.contains(v)) {
            throw new CycleFoundException();
        }
        if (unmarked.contains(v)) {
            tempMarked.add(v);
            for (E edge : graph.outgoingEdgesOf(v)) {
                CycleCheck.visit(graph, unmarked, tempMarked, graph.getEdgeTarget(edge));
            }
            unmarked.remove(v);
            tempMarked.remove(v);
        }
    }
}

