/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.ContainerExit;

final class ImmutableContainerExit
implements ContainerExit {
    private final Long statusCode;

    private ImmutableContainerExit(Long statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    @JsonProperty(value="StatusCode")
    public Long statusCode() {
        return this.statusCode;
    }

    public final ImmutableContainerExit withStatusCode(Long value) {
        Long newValue = Objects.requireNonNull(value, "statusCode");
        if (this.statusCode.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerExit(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerExit && this.equalTo(0, (ImmutableContainerExit)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainerExit another) {
        return this.statusCode.equals(another.statusCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.statusCode.hashCode();
        return h;
    }

    public String toString() {
        return "ContainerExit{statusCode=" + this.statusCode + "}";
    }

    public static ImmutableContainerExit copyOf(ContainerExit instance) {
        if (instance instanceof ImmutableContainerExit) {
            return (ImmutableContainerExit)instance;
        }
        return ImmutableContainerExit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_STATUS_CODE = 1L;
        private long initBits = 1L;
        private Long statusCode;

        private Builder() {
        }

        public final Builder from(ContainerExit instance) {
            Objects.requireNonNull(instance, "instance");
            this.statusCode(instance.statusCode());
            return this;
        }

        @JsonProperty(value="StatusCode")
        public final Builder statusCode(Long statusCode) {
            this.statusCode = Objects.requireNonNull(statusCode, "statusCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableContainerExit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainerExit(this.statusCode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("statusCode");
            }
            return "Cannot build ContainerExit, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

