/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.rpm.core.utils.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class FileDownloadJob
extends Job {
    private File file;
    private URLConnection content;

    public FileDownloadJob(File file, URLConnection content) {
        super(NLS.bind((String)Messages.DownloadJob_0, (Object)file.getName()));
        this.file = file;
        this.content = content;
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(NLS.bind((String)Messages.DownloadJob_0, (Object)this.file.getName()), this.content.getContentLength());
        try (FileOutputStream fos = new FileOutputStream(this.file);
             BufferedInputStream is = new BufferedInputStream(this.content.getInputStream());){
            int b;
            while ((b = ((InputStream)is).read()) != -1) {
                if (monitor.isCanceled()) {
                    break;
                }
                fos.write(b);
                monitor.worked(1);
            }
        }
        catch (IOException e) {
            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.linuxtools.rpm.core")).log(Status.error((String)e.getMessage(), (Throwable)e));
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

