/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ContainerStatus;

final class ImmutableContainerStatus
implements ContainerStatus {
    @Nullable
    private final String containerId;
    @Nullable
    private final Integer pid;
    @Nullable
    private final Long exitCode;

    private ImmutableContainerStatus(@Nullable String containerId, @Nullable Integer pid, @Nullable Long exitCode) {
        this.containerId = containerId;
        this.pid = pid;
        this.exitCode = exitCode;
    }

    @Override
    @JsonProperty(value="ContainerID")
    @Nullable
    public String containerId() {
        return this.containerId;
    }

    @Override
    @JsonProperty(value="PID")
    @Nullable
    public Integer pid() {
        return this.pid;
    }

    @Override
    @JsonProperty(value="ExitCode")
    @Nullable
    public Long exitCode() {
        return this.exitCode;
    }

    public final ImmutableContainerStatus withContainerId(@Nullable String value) {
        if (Objects.equals(this.containerId, value)) {
            return this;
        }
        return new ImmutableContainerStatus(value, this.pid, this.exitCode);
    }

    public final ImmutableContainerStatus withPid(@Nullable Integer value) {
        if (Objects.equals(this.pid, value)) {
            return this;
        }
        return new ImmutableContainerStatus(this.containerId, value, this.exitCode);
    }

    public final ImmutableContainerStatus withExitCode(@Nullable Long value) {
        if (Objects.equals(this.exitCode, value)) {
            return this;
        }
        return new ImmutableContainerStatus(this.containerId, this.pid, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerStatus && this.equalsByValue((ImmutableContainerStatus)another);
    }

    private boolean equalsByValue(ImmutableContainerStatus another) {
        return Objects.equals(this.containerId, another.containerId) && Objects.equals(this.pid, another.pid) && Objects.equals(this.exitCode, another.exitCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.containerId);
        h += (h << 5) + Objects.hashCode(this.pid);
        h += (h << 5) + Objects.hashCode(this.exitCode);
        return h;
    }

    public String toString() {
        return "ContainerStatus{containerId=" + this.containerId + ", pid=" + this.pid + ", exitCode=" + this.exitCode + "}";
    }

    public static ImmutableContainerStatus copyOf(ContainerStatus instance) {
        if (instance instanceof ImmutableContainerStatus) {
            return (ImmutableContainerStatus)instance;
        }
        return ImmutableContainerStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String containerId;
        private Integer pid;
        private Long exitCode;

        private Builder() {
        }

        public final Builder from(ContainerStatus instance) {
            Long exitCodeValue;
            Integer pidValue;
            Objects.requireNonNull(instance, "instance");
            String containerIdValue = instance.containerId();
            if (containerIdValue != null) {
                this.containerId(containerIdValue);
            }
            if ((pidValue = instance.pid()) != null) {
                this.pid(pidValue);
            }
            if ((exitCodeValue = instance.exitCode()) != null) {
                this.exitCode(exitCodeValue);
            }
            return this;
        }

        @JsonProperty(value="ContainerID")
        public final Builder containerId(@Nullable String containerId) {
            this.containerId = containerId;
            return this;
        }

        @JsonProperty(value="PID")
        public final Builder pid(@Nullable Integer pid) {
            this.pid = pid;
            return this;
        }

        @JsonProperty(value="ExitCode")
        public final Builder exitCode(@Nullable Long exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public ImmutableContainerStatus build() {
            return new ImmutableContainerStatus(this.containerId, this.pid, this.exitCode);
        }
    }
}

