/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableVersion
implements Version {
    @Nullable
    private final Long index;

    private ImmutableVersion(@Nullable Long index) {
        this.index = index;
    }

    @Override
    @JsonProperty(value="Index")
    @Nullable
    public Long index() {
        return this.index;
    }

    public final ImmutableVersion withIndex(@Nullable Long value) {
        if (Objects.equals(this.index, value)) {
            return this;
        }
        return new ImmutableVersion(value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVersion && this.equalTo(0, (ImmutableVersion)another);
    }

    private boolean equalTo(int synthetic, ImmutableVersion another) {
        return Objects.equals(this.index, another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.index);
        return h;
    }

    public String toString() {
        return "Version{index=" + this.index + "}";
    }

    public static ImmutableVersion copyOf(Version instance) {
        if (instance instanceof ImmutableVersion) {
            return (ImmutableVersion)instance;
        }
        return ImmutableVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private Long index;

        private Builder() {
        }

        public final Builder from(Version instance) {
            Objects.requireNonNull(instance, "instance");
            Long indexValue = instance.index();
            if (indexValue != null) {
                this.index(indexValue);
            }
            return this;
        }

        @JsonProperty(value="Index")
        public final Builder index(@Nullable Long index) {
            this.index = index;
            return this;
        }

        public ImmutableVersion build() {
            return new ImmutableVersion(this.index);
        }
    }
}

