/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.view.histogram;

import java.util.LinkedList;
import org.eclipse.linuxtools.internal.gprof.symbolManager.Bucket;
import org.eclipse.linuxtools.internal.gprof.view.histogram.AbstractTreeElement;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistBucket;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistFunction;
import org.eclipse.linuxtools.internal.gprof.view.histogram.TreeElement;

public class HistLine
extends AbstractTreeElement {
    public final int line;
    private final LinkedList<HistBucket> children = new LinkedList();

    public HistLine(HistFunction parent, int lineNumber) {
        super(parent);
        this.line = lineNumber;
    }

    void addBucket(Bucket b) {
        this.children.add(new HistBucket(this, b));
    }

    @Override
    public LinkedList<? extends TreeElement> getChildren() {
        return this.children;
    }

    @Override
    public int getCalls() {
        return -1;
    }

    @Override
    public String getName() {
        String functionName = this.getParent().getName();
        return functionName + " (" + this.getParent().getParent().getName() + ":" + this.line + ")";
    }

    @Override
    public int getSamples() {
        int ret = 0;
        for (HistBucket b : this.children) {
            ret += b.getSamples();
        }
        return ret;
    }

    @Override
    public int getSourceLine() {
        return this.line;
    }

    @Override
    public String getSourcePath() {
        return this.getParent().getParent().getSourcePath();
    }
}

