/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.wtp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.format.wtp.XMLFormattingPreferences;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestPartitionFormatterXML {
    private static final String BASE_ROOT = "src/test/resources/wtp/";

    protected void formatAndAssertEquals(String beforePath, String afterPath) throws Exception {
        this.formatAndAssertEquals(beforePath, afterPath, new XMLFormattingPreferences());
    }

    private void formatAndAssertEquals(String beforePath, String afterPath, XMLFormattingPreferences prefs) throws Exception {
        String xml = TestPartitionFormatterXML.readString(new File(BASE_ROOT, beforePath));
        String expected = TestPartitionFormatterXML.readString(new File(BASE_ROOT, afterPath));
        XMLLanguageService ls = new XMLLanguageService();
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().merge((XMLFormattingOptions)prefs);
        String actual = ls.formatFull(xml, "test.xml", settings, () -> {});
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    @Disabled
    public void testSimpleXml() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/simple-standalone.xml", "testfiles/xml/simple-standalone-newfmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testWhitespaceFormatXSD() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-whitespace-xsd.xml", "testfiles/xml/xml-whitespace-xsd-actual.xml");
    }

    @Test
    @Disabled
    public void testPreserveFormat() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/xml-space-preserve-standalone.xml", "testfiles/xml/xml-space-preserve-standalone-newfmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testPreserveFormatDTD() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/xml-space-preserve-dtd.xml", "testfiles/xml/xml-space-preserve-dtd-newfmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testOneLineFormat() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/oneline.xml", "testfiles/xml/oneline-fmt.xml");
    }

    @Test
    @Disabled
    public void testOneLineTextNodeFormat() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/onelineTextNode.xml", "testfiles/xml/onelineTextNode-newfmt.xml");
    }

    @Test
    @Disabled
    public void testEmptyContentNodeFormat() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setIndentMultipleAttributes(true);
        this.formatAndAssertEquals("testfiles/xml/usetagswithemptycontent.xml", "testfiles/xml/usetagswithemptycontent-fmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testXSLFormat() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xslattributetext.xsl", "testfiles/xml/xslattributetext-fmt.xsl");
    }

    @Test
    @Disabled
    public void testEntityFormat() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/entities.xml", "testfiles/xml/entities-newfmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testPreservePCDATAFormat() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setPCDataWhitespaceStrategy("PRESERVE");
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/xml-preservepcdata.xml", "testfiles/xml/xml-preservepcdata-yes-fmt.xml", prefs);
        prefs.setPCDataWhitespaceStrategy("COLLAPSE");
        this.formatAndAssertEquals("testfiles/xml/xml-preservepcdata.xml", "testfiles/xml/xml-preservepcdata-no-newfmt.xml", prefs);
    }

    @Test
    public void testPreserveCDATAFormat() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/usecdata.xml", "testfiles/xml/usecdata-fmt.xml");
    }

    @Test
    public void testPreserveCDATAFormat2() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/usecdata2.xml", "testfiles/xml/usecdata2-fmt.xml");
    }

    @Test
    @Disabled
    public void testSplitAttributesFormat() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setIndentMultipleAttributes(true);
        prefs.setAlignFinalBracket(false);
        this.formatAndAssertEquals("testfiles/xml/multiattributes2.xml", "testfiles/xml/multiattributes2-yessplit-noalign-newfmt.xml", prefs);
        prefs.setIndentMultipleAttributes(false);
        prefs.setAlignFinalBracket(false);
        this.formatAndAssertEquals("testfiles/xml/multiattributes2.xml", "testfiles/xml/multiattributes2-nosplit-noalign-newfmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testAlignEndBracketFormat() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setIndentMultipleAttributes(false);
        prefs.setAlignFinalBracket(true);
        this.formatAndAssertEquals("testfiles/xml/multiattributes.xml", "testfiles/xml/multiattributes-nosplit-yesalign-newfmt.xml", prefs);
        prefs.setIndentMultipleAttributes(true);
        prefs.setAlignFinalBracket(true);
        this.formatAndAssertEquals("testfiles/xml/multiattributes.xml", "testfiles/xml/multiattributes-yessplit-yesalign-newfmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testSpaceBeforeEmptyCloseTag() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setSpaceBeforeEmptyCloseTag(false);
        this.formatAndAssertEquals("testfiles/xml/xml-empty-tag-space.xml", "testfiles/xml/xml-empty-tag-space-none-newfmt.xml", prefs);
        prefs.setSpaceBeforeEmptyCloseTag(true);
        this.formatAndAssertEquals("testfiles/xml/xml-empty-tag-space.xml", "testfiles/xml/xml-empty-tag-space-newfmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testProcessingInstruction() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/processinginstruction.xml", "testfiles/xml/processinginstruction-fmt.xml");
    }

    @Test
    @Disabled
    public void testComments() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-comment.xml", "testfiles/xml/xml-comment-newfmt.xml");
    }

    @Test
    public void testComments_short_NoText() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-comment-short-NoText.xml", "testfiles/xml/xml-comment-short-NoText-formated.xml");
    }

    @Test
    @Disabled
    public void testComments_short_InbetweenText() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-comment-short-InbetweenText.xml", "testfiles/xml/xml-comment-short-InbetweenText-formated.xml");
    }

    @Test
    @Disabled
    public void testComments_short_SameLineText() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-comment-short-SameLineText.xml", "testfiles/xml/xml-comment-short-SameLineText-formated.xml");
    }

    @Test
    @Disabled
    public void testComments_short_EverywhereText() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-comment-short-EverywhereText.xml", "testfiles/xml/xml-comment-short-EverywhereText-formated.xml");
    }

    @Test
    @Disabled
    public void testComments_long_NoText() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-comment-long-NoText.xml", "testfiles/xml/xml-comment-long-NoText-formated.xml");
    }

    @Test
    @Disabled
    public void testComments_long_InbetweenText() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-comment-long-InbetweenText.xml", "testfiles/xml/xml-comment-long-InbetweenText-formated.xml");
    }

    @Test
    @Disabled
    public void testComments_long_SameLineText() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-comment-long-SameLineText.xml", "testfiles/xml/xml-comment-long-SameLineText-formated.xml");
    }

    @Test
    @Disabled
    public void testComments_long_EverywhereText() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-comment-long-EverywhereText.xml", "testfiles/xml/xml-comment-long-EverywhereText-formated.xml");
    }

    @Test
    @Disabled
    public void testKeepEmptyLines() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(false);
        this.formatAndAssertEquals("testfiles/xml/xml-keep-blank-lines.xml", "testfiles/xml/xml-keep-blank-lines-fmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testClearBlankLines() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setClearAllBlankLines(true);
        this.formatAndAssertEquals("testfiles/xml/xml-keep-blank-lines.xml", "testfiles/xml/xml-clear-blank-lines-fmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testFormatMalformedEndTag() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-221279.xml", "testfiles/xml/xml-221279-fmt.xml");
    }

    @Test
    @Disabled
    public void testFormatWithFracturedXMLContent() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-229135.xml", "testfiles/xml/xml-229135-fmt.xml");
    }

    @Test
    @Disabled
    public void testFormatCommentsJoinLinesDisabled() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setJoinCommentLines(false);
        this.formatAndAssertEquals("testfiles/xml/xml-join-lines-disabled.xml", "testfiles/xml/xml-join-lines-disabled-fmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testFormatCommentsDisabled() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setFormatCommentText(false);
        this.formatAndAssertEquals("testfiles/xml/xml-format-comments-disabled.xml", "testfiles/xml/xml-format-comments-disabled-fmt.xml", prefs);
    }

    @Test
    @Disabled
    public void testFormatDocumentLevelComment() throws Exception {
        XMLFormattingPreferences prefs = new XMLFormattingPreferences();
        prefs.setJoinCommentLines(false);
        this.formatAndAssertEquals("testfiles/xml/xml-format-document-level-comment.xml", "testfiles/xml/xml-format-document-level-comment-fmt.xml", prefs);
    }

    @Test
    public void testFormatDocumentLevelShortComment() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/xml-format-document-level-short-comment.xml", "testfiles/xml/xml-format-document-level-short-comment-fmt.xml");
    }

    @Test
    @Disabled
    public void testNestedEndTag() throws Exception {
        this.formatAndAssertEquals("testfiles/xml/nested-endtag.xml", "testfiles/xml/nested-endtag-fmt.xml");
    }

    private static String readString(File file) throws FileNotFoundException, IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String string = IOUtils.convertStreamToString((InputStream)in);
            return string;
        }
    }
}

