/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.filepath.participants;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.filepath.participants.AbstractFilePathCompletionTest;
import org.eclipse.lemminx.utils.platform.Platform;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class FilePathCompletionWithSettingsTest
extends AbstractFilePathCompletionTest {
    @Test
    public void empty() throws BadLocationException {
        String xml = "<a path=\"|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 9, 9, "folderA", "folderB", "folderC", "NestedA", "main.xml", "main.xsd", "main.xsl", "main.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 8, items);
    }

    @Test
    public void testFilePathCompletion() throws BadLocationException {
        String xml = "<a path=\"./|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 11, 11, "folderA", "folderB", "folderC", "NestedA", "main.xml", "main.xsd", "main.xsl", "main.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 8, items);
    }

    @Test
    public void testFilePathCompletionBackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<a path=\".\\|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 11, 11, "folderA", "folderB", "folderC", "NestedA", "main.xml", "main.xsd", "main.xsl", "main.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 8, items);
    }

    @Test
    public void testFilePathCompletionFolderA() throws BadLocationException {
        String xml = "<a path=\"./folderA/|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 19, 19, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionFolderABackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<a path=\".\\folderA\\|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 19, 19, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionFolderB() throws BadLocationException {
        String xml = "<a path=\"folderB/|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 17, 17, "xsdB1.xsd", "xmlB1.xml", "dtdB1.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 3, items);
    }

    @Test
    public void testFilePathCompletionFolderBBackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<a path=\"folderB\\|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 17, 17, "xsdB1.xsd", "xmlB1.xml", "dtdB1.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 3, items);
    }

    @Test
    public void testFilePathCompletionFolderBAbsolutePath() throws BadLocationException {
        String filePath = userDirForwardSlash + "/src/test/resources/filePathCompletion/folderB/";
        int filePathLength = filePath.length();
        String xml = "<a path=\"" + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 9 + filePathLength, 9 + filePathLength, "xsdB1.xsd", "xmlB1.xml", "dtdB1.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 3, items);
    }

    @Test
    public void testFilePathCompletionFolderBAbsolutePathBackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String filePath = userDirBackSlash + "\\src\\test\\resources\\filePathCompletion\\folderB\\";
        int filePathLength = filePath.length();
        String xml = "<a path=\"" + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 9 + filePathLength, 9 + filePathLength, "xsdB1.xsd", "xmlB1.xml", "dtdB1.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 3, items);
    }

    @Test
    public void testFilePathCompletionFolderBAbsolutePathWithFileScheme() throws BadLocationException {
        String filePath = (Platform.isWindows ? "file:///" : "file://") + userDirForwardSlash + "/src/test/resources/filePathCompletion/folderB/";
        int filePathLength = filePath.length();
        String xml = "<a path=\"" + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 9 + filePathLength, 9 + filePathLength, "xsdB1.xsd", "xmlB1.xml", "dtdB1.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 3, items);
    }

    @Test
    public void testFilePathCompletionNestedA() throws BadLocationException {
        String xml = "<a path=\"./NestedA/|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 19, 19, "NestedB");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionNestedABackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<a path=\"./NestedA\\|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 19, 19, "NestedB");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionNestedBIncomplete() throws BadLocationException {
        String xml = "<a path=\"./NestedA/NestedB/ZZZ|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 27, 30, "nestedXSD.xsd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionNestedBIncompleteBackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<a path=\".\\NestedA\\NestedB\\ZZZ|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 27, 30, "nestedXSD.xsd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionExtraTextInValue() throws BadLocationException {
        String xml = "<a path=\"NAMESPACE_IGNORE_ME NestedA/NestedB/|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionExtraTextInValueBackSlash() throws BadLocationException {
        String xml = "<a path=\"NAMESPACE_IGNORE_ME NestedA\\NestedB\\|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionBadFolder() throws BadLocationException {
        String xml = "<a path=\"NestedA/BAD_FOLDER/|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionBadFolderBackSlash() throws BadLocationException {
        String xml = "<a path=\"NestedA\\BAD_FOLDER\\|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionStartWithDotDot() throws BadLocationException {
        String xml = "<a path=\"../filePathCompletion/folderA/|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 39, 39, "xsdA1.xsd", "xsdA2.xsd", "dtdA1.dtd", "dtdA2.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 4, items);
    }

    @Test
    public void testFilePathCompletionStartWithDotDotBackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<a path=\"..\\filePathCompletion\\folderA\\|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 39, 39, "xsdA1.xsd", "xsdA2.xsd", "dtdA1.dtd", "dtdA2.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 4, items);
    }

    @Test
    public void testFilePathCompletionStartWithDot() throws BadLocationException {
        String xml = "<a path=\"./folderA/|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 19, 19, "xsdA1.xsd", "xsdA2.xsd", "dtdA1.dtd", "dtdA2.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 4, items);
    }

    @Test
    public void testFilePathCompletionStartWithDotBackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<a path=\".\\folderA\\|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 19, 19, "xsdA1.xsd", "xsdA2.xsd", "dtdA1.dtd", "dtdA2.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 4, items);
    }

    @Test
    public void testFilePathCompletionEndsWithFileAndSlash() throws BadLocationException {
        String xml = "<a path=\"./randomFile.aaa/|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionEndsWithFileAndBackSlash() throws BadLocationException {
        String xml = "<a path=\".\\randomFile.aaa\\|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionWithSpacesFolder() throws BadLocationException {
        String xml = "<a path=\"./folderC/|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 19, 19, "a@b", "with%20spaces");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionInsideSpecialChars() throws BadLocationException {
        String xml = "<a path=\"../|\">";
        String fileURI = "file://" + userDirForwardSlash + "/src/test/resources/filePathCompletion/folderC/a@b/foo.xml";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 12, 12, "a@b", "with%20spaces");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, fileURI, 2, items);
    }

    @Disabled
    @Test
    public void testFilePathCompletionWithBrokenAbsoluteWindowsPath() throws BadLocationException {
        String xml = "<a path=\"C|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
        xml = "<a path=\"C:|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
        xml = "<a path=\"C\\\\|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
        xml = "<a path=\"C::|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionExtraTextInValueAbsolute() throws BadLocationException {
        String filePath = userDirForwardSlash + "/src/test/resources/filePathCompletion/NestedA/NestedB/";
        int filePathLength = filePath.length();
        String xml = "<a paths=\"NAMESPACE_IGNORE_ME " + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 30 + filePathLength, 30 + filePathLength, "nestedXSD.xsd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionExtraTextInValueAbsoluteBackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String filePath = userDirBackSlash + "\\src\\test\\resources\\filePathCompletion\\NestedA\\NestedB\\";
        int filePathLength = filePath.length();
        String xml = "<a path=\"NAMESPACE_IGNORE_ME " + filePath + "|\">";
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 0, new CompletionItem[0]);
        xml = "<a paths=\"NAMESPACE_IGNORE_ME " + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 30 + filePathLength, 30 + filePathLength, "nestedXSD.xsd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void beforeFirstPath() throws BadLocationException {
        String xml = "<a paths=\"| NestedA\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 10, 10, "folderA", "folderB", "folderC", "NestedA", "main.xml", "main.xsd", "main.xsl", "main.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 8, items);
    }

    @Test
    public void afterFirstPath() throws BadLocationException {
        String xml = "<a paths=\"NestedA |\">";
        CompletionItem[] items = FilePathCompletionWithSettingsTest.getCompletionItemList(0, 18, 18, "folderA", "folderB", "folderC", "NestedA", "main.xml", "main.xsd", "main.xsl", "main.dtd");
        FilePathCompletionWithSettingsTest.testCompletionFor(xml, 8, items);
    }
}

