/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.filepath.participants;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.filepath.FilePathSettingsUtils;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lsp4j.CompletionItem;

public abstract class AbstractFilePathCompletionTest
extends AbstractCacheBasedTest {
    private static final String userDir = FilesUtils.encodePath((String)System.getProperty("user.dir"));
    protected static final String userDirBackSlash = userDir.replace("/", "\\");
    protected static final String userDirForwardSlash = userDir.replace("\\", "/");

    protected static void testCompletionFor(String xml, CompletionItem ... expectedItems) throws BadLocationException {
        AbstractFilePathCompletionTest.testCompletionFor(xml, null, expectedItems);
    }

    protected static void testCompletionFor(String xml, Integer expectedItemCount, CompletionItem ... expectedItems) throws BadLocationException {
        String fileURI = AbstractFilePathCompletionTest.getFileUri("main.xml");
        AbstractFilePathCompletionTest.testCompletionFor(xml, fileURI, expectedItemCount, expectedItems);
    }

    protected static String getFileUri(String fileName) {
        return "file://" + userDirForwardSlash + "/src/test/resources/filePathCompletion/" + fileName;
    }

    protected static void testCompletionFor(String xml, String fileURI, Integer expectedItemCount, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, null, (XMLLanguageService ls) -> ls.doSave((ISaveContext)new XMLAssert.SettingsSaveContext(FilePathSettingsUtils.createFilePathsSettings())), fileURI, expectedItemCount, true, expectedItems);
    }

    protected static CompletionItem[] getCompletionItemList(int line, int startChar, int endChar, String ... fileOrFolderNames) {
        int fOfSize = fileOrFolderNames.length;
        CompletionItem[] items = new CompletionItem[fOfSize];
        for (int i = 0; i < fOfSize; ++i) {
            String fOf = fileOrFolderNames[i];
            items[i] = XMLAssert.c(fOf, XMLAssert.te(line, startChar, line, endChar, fOf), fOf);
        }
        return items;
    }
}

