/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom.parser;

import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLScannerForInternalDTDTest {
    public Scanner scanner;

    @Test
    public void testDocumentTypeInternalOnly() {
        String xml = "<!DOCTYPE note [\n  <!ENTITY nbsp \"&#xA0;\"> \n  <!ENTITY writer \"Writer: Donald Duck.\">\n]>";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(16, TokenType.Content);
        this.assertOffsetAndToken(19, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(27, TokenType.Whitespace);
        this.assertOffsetAndToken(28, TokenType.DTDEntityName);
        this.assertOffsetAndToken(32, TokenType.Whitespace);
        this.assertOffsetAndToken(33, TokenType.DTDEntityValue);
        this.assertOffsetAndToken(41, TokenType.DTDEndTag);
        this.assertOffsetAndToken(42, TokenType.Content);
        this.assertOffsetAndToken(46, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(54, TokenType.Whitespace);
        this.assertOffsetAndToken(55, TokenType.DTDEntityName);
        this.assertOffsetAndToken(61, TokenType.Whitespace);
        this.assertOffsetAndToken(62, TokenType.DTDEntityValue);
        this.assertOffsetAndToken(84, TokenType.DTDEndTag);
        this.assertOffsetAndToken(85, TokenType.Content);
        this.assertOffsetAndToken(86, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(87, TokenType.DTDEndDoctypeTag);
    }

    @Test
    public void testDocumentTypePublicAndInternal() {
        String xml = "<!DOCTYPE html PUBLIC\n  \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\n  [\n    <!ENTITY nbsp \"&#xA0;\"> \n  ]\n>";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDDocTypeKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDDoctypePublicId);
        this.assertOffsetAndToken(64, TokenType.Whitespace);
        this.assertOffsetAndToken(67, TokenType.DTDDoctypeSystemId);
        this.assertOffsetAndToken(124, TokenType.Whitespace);
        this.assertOffsetAndToken(127, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(128, TokenType.Content);
        this.assertOffsetAndToken(133, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(141, TokenType.Whitespace);
        this.assertOffsetAndToken(142, TokenType.DTDEntityName);
        this.assertOffsetAndToken(146, TokenType.Whitespace);
        this.assertOffsetAndToken(147, TokenType.DTDEntityValue);
        this.assertOffsetAndToken(155, TokenType.DTDEndTag);
        this.assertOffsetAndToken(156, TokenType.Content);
        this.assertOffsetAndToken(160, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(161, TokenType.Whitespace);
        this.assertOffsetAndToken(162, TokenType.DTDEndDoctypeTag);
        this.assertOffsetAndToken(163, TokenType.EOS);
    }

    @Test
    public void testDocumentTypeSystemAndInternal() {
        String xml = "<!DOCTYPE html SYSTEM\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\n  [\n    <!ELEMENT test (a)> \n  ]\n>";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDDocTypeKindSYSTEM);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDDoctypeSystemId);
        this.assertOffsetAndToken(81, TokenType.Whitespace);
        this.assertOffsetAndToken(84, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(85, TokenType.Content);
        this.assertOffsetAndToken(90, TokenType.DTDStartElement);
        this.assertOffsetAndToken(99, TokenType.Whitespace);
        this.assertOffsetAndToken(100, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(104, TokenType.Whitespace);
        this.assertOffsetAndToken(105, TokenType.DTDStartElementContent);
        this.assertOffsetAndToken(106, TokenType.DTDElementContent);
        this.assertOffsetAndToken(107, TokenType.DTDEndElementContent);
        this.assertOffsetAndToken(108, TokenType.DTDEndTag);
        this.assertOffsetAndToken(109, TokenType.Content);
        this.assertOffsetAndToken(113, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(114, TokenType.Whitespace);
        this.assertOffsetAndToken(115, TokenType.DTDEndDoctypeTag);
        this.assertOffsetAndToken(116, TokenType.EOS);
    }

    @Test
    public void testDocumentTypeSystemAndInternalAttlist() {
        String xml = "<!DOCTYPE html SYSTEM\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\n  [\n    <!ATTLIST payment type CDATA \"cheque\"> \n  ]\n>";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDDocTypeKindSYSTEM);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDDoctypeSystemId);
        this.assertOffsetAndToken(81, TokenType.Whitespace);
        this.assertOffsetAndToken(84, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(85, TokenType.Content);
        this.assertOffsetAndToken(90, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(99, TokenType.Whitespace);
        this.assertOffsetAndToken(100, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(107, TokenType.Whitespace);
        this.assertOffsetAndToken(108, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(112, TokenType.Whitespace);
        this.assertOffsetAndToken(113, TokenType.DTDAttlistAttributeType);
        this.assertOffsetAndToken(118, TokenType.Whitespace);
        this.assertOffsetAndToken(119, TokenType.DTDAttlistAttributeValue);
        this.assertOffsetAndToken(127, TokenType.DTDEndTag);
        this.assertOffsetAndToken(128, TokenType.Content);
        this.assertOffsetAndToken(132, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(133, TokenType.Whitespace);
        this.assertOffsetAndToken(134, TokenType.DTDEndDoctypeTag);
        this.assertOffsetAndToken(135, TokenType.EOS);
    }

    @Test
    public void testDocumentTypeSystemAndInternalAttlist2() {
        String xml = "<!DOCTYPE html SYSTEM\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\n  [\n    <!ATTLIST payment type (first|second) \"first\"> \n  ]\n>";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDDocTypeKindSYSTEM);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDDoctypeSystemId);
        this.assertOffsetAndToken(81, TokenType.Whitespace);
        this.assertOffsetAndToken(84, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(85, TokenType.Content);
        this.assertOffsetAndToken(90, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(99, TokenType.Whitespace);
        this.assertOffsetAndToken(100, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(107, TokenType.Whitespace);
        this.assertOffsetAndToken(108, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(112, TokenType.Whitespace);
        this.assertOffsetAndToken(113, TokenType.DTDAttlistAttributeType);
        this.assertOffsetAndToken(127, TokenType.Whitespace);
        this.assertOffsetAndToken(128, TokenType.DTDAttlistAttributeValue);
        this.assertOffsetAndToken(135, TokenType.DTDEndTag);
        this.assertOffsetAndToken(136, TokenType.Content);
        this.assertOffsetAndToken(140, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(141, TokenType.Whitespace);
        this.assertOffsetAndToken(142, TokenType.DTDEndDoctypeTag);
        this.assertOffsetAndToken(143, TokenType.EOS);
    }

    @Test
    public void testDocumentTypeSystemAndEmptyInternalDTD() {
        String xml = "<!DOCTYPE html SYSTEM\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\n  [\n  ]\n>";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDDocTypeKindSYSTEM);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDDoctypeSystemId);
        this.assertOffsetAndToken(81, TokenType.Whitespace);
        this.assertOffsetAndToken(84, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(85, TokenType.Content);
        this.assertOffsetAndToken(88, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(89, TokenType.Whitespace);
        this.assertOffsetAndToken(90, TokenType.DTDEndDoctypeTag);
        this.assertOffsetAndToken(91, TokenType.EOS);
    }

    @Test
    public void testDocumentTypeSystem() {
        String xml = "<!DOCTYPE html SYSTEM\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\n>";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDDocTypeKindSYSTEM);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDDoctypeSystemId);
        this.assertOffsetAndToken(81, TokenType.Whitespace);
        this.assertOffsetAndToken(82, TokenType.DTDEndDoctypeTag);
    }

    @Test
    public void oneElementDeclNotClosed() {
        String xml = "<!DOCTYPE foo [\r\n<!ELEMENT a]>   \r\n<foo />";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(13, TokenType.Whitespace);
        this.assertOffsetAndToken(14, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(15, TokenType.Content);
        this.assertOffsetAndToken(17, TokenType.DTDStartElement);
        this.assertOffsetAndToken(26, TokenType.Whitespace);
        this.assertOffsetAndToken(27, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(28, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(29, TokenType.DTDEndDoctypeTag);
        this.assertOffsetAndToken(30, TokenType.Content);
        this.assertOffsetAndToken(35, TokenType.StartTagOpen);
        this.assertOffsetAndToken(36, TokenType.StartTag);
        this.assertOffsetAndToken(39, TokenType.Whitespace);
        this.assertOffsetAndToken(40, TokenType.StartTagSelfClose);
        this.assertOffsetAndToken(42, TokenType.EOS);
    }

    @Test
    public void startWithElementDeclNotClosed() {
        String xml = "<!DOCTYPE foo [\r\n<!ELEMENT a\r\n<!ELEMENT b]>   \r\n<foo />";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(13, TokenType.Whitespace);
        this.assertOffsetAndToken(14, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(15, TokenType.Content);
        this.assertOffsetAndToken(17, TokenType.DTDStartElement);
        this.assertOffsetAndToken(26, TokenType.Whitespace);
        this.assertOffsetAndToken(27, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(28, TokenType.Whitespace);
        this.assertOffsetAndToken(30, TokenType.DTDStartElement);
        this.assertOffsetAndToken(39, TokenType.Whitespace);
        this.assertOffsetAndToken(40, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(41, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(42, TokenType.DTDEndDoctypeTag);
        this.assertOffsetAndToken(43, TokenType.Content);
        this.assertOffsetAndToken(48, TokenType.StartTagOpen);
        this.assertOffsetAndToken(49, TokenType.StartTag);
        this.assertOffsetAndToken(52, TokenType.Whitespace);
        this.assertOffsetAndToken(53, TokenType.StartTagSelfClose);
        this.assertOffsetAndToken(55, TokenType.EOS);
    }

    @Test
    public void startWithNotationDeclNotClosed() {
        String xml = "<!DOCTYPE foo [\r\n  <!NOTATION a\r\n]\r\n<foo />";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(13, TokenType.Whitespace);
        this.assertOffsetAndToken(14, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(15, TokenType.Content);
        this.assertOffsetAndToken(19, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(29, TokenType.Whitespace);
        this.assertOffsetAndToken(30, TokenType.DTDNotationName);
        this.assertOffsetAndToken(31, TokenType.Whitespace);
        this.assertOffsetAndToken(33, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(34, TokenType.Whitespace);
        this.assertOffsetAndToken(36, TokenType.StartTagOpen);
        this.assertOffsetAndToken(37, TokenType.StartTag);
        this.assertOffsetAndToken(40, TokenType.Whitespace);
        this.assertOffsetAndToken(41, TokenType.StartTagSelfClose);
        this.assertOffsetAndToken(43, TokenType.EOS);
    }

    @Test
    public void startWithNotationDeclNotClosedWithContent() {
        String xml = "<!DOCTYPE foo [\r\n  <!NOTATION a\r\n] CONTENT\r\n<foo />";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(13, TokenType.Whitespace);
        this.assertOffsetAndToken(14, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(15, TokenType.Content);
        this.assertOffsetAndToken(19, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(29, TokenType.Whitespace);
        this.assertOffsetAndToken(30, TokenType.DTDNotationName);
        this.assertOffsetAndToken(31, TokenType.Whitespace);
        this.assertOffsetAndToken(33, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(34, TokenType.Whitespace);
        this.assertOffsetAndToken(35, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(44, TokenType.StartTagOpen);
        this.assertOffsetAndToken(45, TokenType.StartTag);
        this.assertOffsetAndToken(48, TokenType.Whitespace);
        this.assertOffsetAndToken(49, TokenType.StartTagSelfClose);
        this.assertOffsetAndToken(51, TokenType.EOS);
    }

    @Test
    public void startWithEntityDeclNotClosedWithContent() {
        String xml = "<!DOCTYPE foo [\r\n  <!ENTITY a\r\n] CONTENT\r\n<foo />";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(13, TokenType.Whitespace);
        this.assertOffsetAndToken(14, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(15, TokenType.Content);
        this.assertOffsetAndToken(19, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(27, TokenType.Whitespace);
        this.assertOffsetAndToken(28, TokenType.DTDEntityName);
        this.assertOffsetAndToken(29, TokenType.Whitespace);
        this.assertOffsetAndToken(31, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(32, TokenType.Whitespace);
        this.assertOffsetAndToken(33, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(42, TokenType.StartTagOpen);
        this.assertOffsetAndToken(43, TokenType.StartTag);
        this.assertOffsetAndToken(46, TokenType.Whitespace);
        this.assertOffsetAndToken(47, TokenType.StartTagSelfClose);
        this.assertOffsetAndToken(49, TokenType.EOS);
    }

    @Test
    public void startWithAttlistDeclNotClosed() {
        String xml = "<!DOCTYPE foo [\r\n  <!ATTLIST \r\n]\r\n<foo />";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(13, TokenType.Whitespace);
        this.assertOffsetAndToken(14, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(15, TokenType.Content);
        this.assertOffsetAndToken(19, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(28, TokenType.Whitespace);
        this.assertOffsetAndToken(31, TokenType.DTDEndInternalSubset);
        this.assertOffsetAndToken(32, TokenType.Whitespace);
        this.assertOffsetAndToken(34, TokenType.StartTagOpen);
        this.assertOffsetAndToken(35, TokenType.StartTag);
        this.assertOffsetAndToken(38, TokenType.Whitespace);
        this.assertOffsetAndToken(39, TokenType.StartTagSelfClose);
        this.assertOffsetAndToken(41, TokenType.EOS);
    }

    @Test
    public void startWithAttlistDeclNotClosedAndMissingEndInternalSubset() {
        String xml = "<!DOCTYPE foo [\r\n  <!ATTLIST \r\n\r\n<foo />";
        this.scanner = XMLScanner.createScanner((String)xml);
        this.assertOffsetAndToken(0, TokenType.DTDStartDoctypeTag);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDDoctypeName);
        this.assertOffsetAndToken(13, TokenType.Whitespace);
        this.assertOffsetAndToken(14, TokenType.DTDStartInternalSubset);
        this.assertOffsetAndToken(15, TokenType.Content);
        this.assertOffsetAndToken(19, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(28, TokenType.Whitespace);
        this.assertOffsetAndToken(33, TokenType.Content);
        this.assertOffsetAndToken(40, TokenType.EOS);
    }

    public void assertOffsetAndToken(int tokenOffset, TokenType tokenType) {
        TokenType token = this.scanner.scan();
        Assertions.assertEquals((int)tokenOffset, (int)this.scanner.getTokenOffset());
        Assertions.assertEquals((Object)tokenType, (Object)token);
    }

    public void assertOffsetAndToken(int tokenOffset, TokenType tokenType, String tokenText) {
        TokenType token = this.scanner.scan();
        Assertions.assertEquals((int)tokenOffset, (int)this.scanner.getTokenOffset());
        Assertions.assertEquals((Object)tokenType, (Object)token);
        Assertions.assertEquals((Object)tokenText, (Object)this.scanner.getTokenText());
    }
}

