/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javasoft.sqe.apiCheck.Fatal;
import javasoft.sqe.apiCheck.XClass;
import javasoft.sqe.apiCheck.XPack;
import javasoft.sqe.apiCheck.XProgWalk;
import javasoft.sqe.apiCheck.XType;
import javasoft.sqe.apiCheck.XTypeArray;
import javasoft.sqe.apiCheck.XTypeClass;
import javasoft.sqe.apiCheck.XTypePrimitive;
import javasoft.sqe.apiCheck.XTypes;

class XProg {
    XPack packs = new XPack();
    HashMap classhash = new HashMap();
    Vector typesclass = new Vector();
    Vector typesarray = new Vector();
    static XTypePrimitive[] typesprimitive = new XTypePrimitive[]{new XTypePrimitive("void", 'V'), new XTypePrimitive("boolean", 'Z'), new XTypePrimitive("byte", 'B'), new XTypePrimitive("short", 'S'), new XTypePrimitive("int", 'I'), new XTypePrimitive("long", 'J'), new XTypePrimitive("char", 'C'), new XTypePrimitive("float", 'F'), new XTypePrimitive("double", 'D')};

    XProg() {
    }

    XType DefineVMType(StringBuffer s) {
        int dims = 0;
        while (s.charAt(0) == '[') {
            ++dims;
            s.deleteCharAt(0);
        }
        XType ref = null;
        char chr = s.charAt(0);
        s.deleteCharAt(0);
        if (chr == 'L') {
            int k;
            for (k = 0; k < s.length() && s.charAt(k) != ';'; ++k) {
            }
            if (k > 0) {
                ref = this.DefineType(s.substring(0, k).replace('/', '.'));
                s.delete(0, k + 1);
            }
        } else {
            ref = XProg.DefineTypePrimitive(chr);
        }
        if (ref == null) {
            Fatal.Stop("invalid VM type " + s);
        }
        if (dims == 0) {
            return ref;
        }
        return this.DefineTypeArray(ref, dims);
    }

    XTypes DefineTypes(String[] ss) {
        XTypes tt;
        if (ss != null) {
            tt = new XTypes(ss.length);
            for (int i = 0; i < ss.length; ++i) {
                tt.Add(this.DefineType(ss[i]));
            }
        } else {
            tt = new XTypes(0);
        }
        return tt;
    }

    XType DefineType(String s) {
        XTypeClass tc;
        if (s.startsWith("[")) {
            int dims = 0;
            while (s.charAt(dims) == '[') {
                ++dims;
            }
            char chr = s.charAt(dims);
            XType ref = null;
            ref = chr == 'L' ? this.DefineType(s.substring(dims + 1, s.length() - 1)) : XProg.DefineTypePrimitive(chr);
            return this.DefineTypeArray(ref, dims);
        }
        int dims = 0;
        while (s.endsWith("[]")) {
            s = s.substring(0, s.length() - 2);
            ++dims;
        }
        if (dims > 0) {
            return this.DefineTypeArray(this.DefineType(s), dims);
        }
        XTypePrimitive tp = XProg.DefineTypePrimitive(s);
        if (tp != null) {
            return tp;
        }
        XClass r = this.DefineClass(s);
        Enumeration e = this.typesclass.elements();
        while (e.hasMoreElements()) {
            tc = (XTypeClass)e.nextElement();
            if (tc.ref != r) continue;
            return tc;
        }
        tc = new XTypeClass(r);
        this.typesclass.addElement(tc);
        return tc;
    }

    static XTypePrimitive DefineTypePrimitive(char c) {
        for (int i = 0; i < typesprimitive.length; ++i) {
            XTypePrimitive t = typesprimitive[i];
            if (t.chr != c) continue;
            return t;
        }
        return null;
    }

    static XTypePrimitive DefineTypePrimitive(String s) {
        for (int i = 0; i < typesprimitive.length; ++i) {
            XTypePrimitive t = typesprimitive[i];
            if (!t.name.equals(s)) continue;
            return t;
        }
        return null;
    }

    XTypeArray DefineTypeArray(XType ref, int dims) {
        if (ref == null) {
            Fatal.Stop("DefineTypeArray");
        }
        XTypeArray t = null;
        Enumeration e = this.typesarray.elements();
        while (e.hasMoreElements()) {
            t = (XTypeArray)e.nextElement();
            if (t.ref != ref || t.dims != dims) continue;
            return t;
        }
        t = new XTypeArray(ref, dims);
        this.typesarray.addElement(t);
        return t;
    }

    XPack DefinePack(Vector pnames, boolean create) {
        XPack p = this.packs;
        for (int i = 0; i < pnames.size(); ++i) {
            String s = (String)pnames.elementAt(i);
            XPack q = (XPack)p.packs.FindFirst(s);
            if (q == null) {
                if (!create) {
                    Fatal.Stop("Package not found: " + s);
                }
                q = new XPack();
                q.name = s;
                q.Link(p);
            }
            p = q;
        }
        return p;
    }

    XClass DefineClass(String qname) {
        XClass c = (XClass)this.classhash.get(qname);
        if (c != null) {
            return c;
        }
        String err = "Invalid class name: \"" + qname + "\"";
        String n = null;
        XPack p = this.packs;
        if (qname.charAt(0) == '.') {
            qname = qname.substring(1);
        }
        StringTokenizer st = new StringTokenizer(qname + "=", ".$=", true);
        while (st.hasMoreTokens()) {
            XClass cc;
            String s = st.nextToken();
            if (s.equals(".")) {
                if (n == null) {
                    Fatal.Stop(err);
                }
                if (c == null) {
                    cc = (XClass)p.classes.FindFirst(n);
                    if (cc != null) {
                        c = cc;
                        p = null;
                    } else {
                        XPack pp = (XPack)p.packs.FindFirst(n);
                        if (pp == null) {
                            pp = new XPack();
                            pp.name = n;
                            pp.Link(p);
                        }
                        p = pp;
                    }
                } else {
                    cc = (XClass)c.inners.FindFirst(n);
                    if (cc == null) {
                        cc = new XClass();
                        cc.name = n;
                        cc.Link(c);
                    }
                    c = cc;
                    p = null;
                }
                n = null;
                continue;
            }
            if (s.equals("$") || s.equals("=")) {
                if (n == null) {
                    Fatal.Stop(err);
                }
                if (c == null) {
                    cc = (XClass)p.classes.FindFirst(n);
                    if (cc == null) {
                        if (p.packs.FindFirst(n) != null) {
                            System.err.println("package/class name clash " + n);
                        }
                        cc = new XClass();
                        cc.name = n;
                        cc.Link(p);
                    }
                } else {
                    cc = (XClass)c.inners.FindFirst(n);
                    if (cc == null) {
                        cc = new XClass();
                        cc.name = n;
                        cc.Link(c);
                    }
                }
                c = cc;
                n = null;
                continue;
            }
            if (n != null) {
                Fatal.Stop(err);
            }
            n = s;
        }
        if (c == null || n != null) {
            Fatal.Stop(err);
        }
        this.classhash.put(qname, c);
        return c;
    }

    void Sort() {
        Sorter sort = new Sorter();
        sort.Walk(this, null);
    }

    boolean IsEmpty() {
        return XProg.IsEmpty(this.packs);
    }

    static boolean IsEmpty(XPack xpack) {
        Enumeration e = xpack.classes.elements();
        while (e.hasMoreElements()) {
            if (!((XClass)e.nextElement()).defined) continue;
            return false;
        }
        e = xpack.packs.elements();
        while (e.hasMoreElements()) {
            if (XProg.IsEmpty((XPack)e.nextElement())) continue;
            return false;
        }
        return true;
    }

    static class ObjComparator
    implements Comparator {
        ObjComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    static class Sorter
    extends XProgWalk {
        ObjComparator oc = new ObjComparator();

        Sorter() {
        }

        @Override
        void Walk(XPack x) {
            Collections.sort(x.packs, this.oc);
            Collections.sort(x.classes, this.oc);
            super.Walk(x);
        }

        @Override
        void Walk(XClass x) {
            Collections.sort(x.constructors, this.oc);
            Collections.sort(x.methods, this.oc);
            Collections.sort(x.fields, this.oc);
            Collections.sort(x.inners, this.oc);
            super.Walk(x);
        }
    }
}

