/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import jakarta.validation.Validator;
import jakarta.validation.constraints.Email;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class EmailConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)EmailConstraintTest.webArchiveBuilder().withTestClass(EmailConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-email", id="a")})
    public void testEmailConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        EmailDummyEntity foo = new EmailDummyEntity("test@example.com");
        Set constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Email.class).withProperty("email"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-email", id="a")})
    public void testEmailConstraintOnStringBuilder() {
        Validator validator = TestUtil.getValidatorUnderTest();
        EmailStringBuilderDummyEntity foo = new EmailStringBuilderDummyEntity(new StringBuilder("test@example.com"));
        Set constraintViolations = validator.validate((Object)foo, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Email.class).withProperty("email"));
    }

    private class EmailDummyEntity {
        @Email(regexp="^invalid$")
        private @Email(regexp="^invalid$") String email;

        private EmailDummyEntity(String email) {
            this.email = email;
        }
    }

    private class EmailStringBuilderDummyEntity {
        @Email(regexp="^invalid$")
        private @Email(regexp="^invalid$") StringBuilder email;

        private EmailStringBuilderDummyEntity(StringBuilder email) {
            this.email = email;
        }
    }
}

