/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.provider;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.server.features.navigation.JsonOpenerOptions;
import org.eclipse.glsp.server.features.navigation.NavigationTarget;
import org.eclipse.glsp.server.features.navigation.NavigationTargetProvider;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.EditorContext;
import org.eclipse.glsp.server.utils.MapUtil;

public class NodeDocumentationNavigationTargetProvider
implements NavigationTargetProvider {
    @Inject
    protected GModelState modelState;

    public String getTargetTypeId() {
        return "documentation";
    }

    public List<? extends NavigationTarget> getTargets(EditorContext editorContext) {
        if (editorContext.getSelectedElementIds().size() == 1) {
            Optional taskNode = this.modelState.getIndex().findElementByClass((String)editorContext.getSelectedElementIds().get(0), TaskNode.class);
            if (taskNode.isEmpty() || !((TaskNode)taskNode.get()).getId().equals("task0")) {
                return Arrays.asList(new NavigationTarget[0]);
            }
            Optional sourceUri = MapUtil.getValue((Map)this.modelState.getClientOptions(), (String)"sourceUri");
            if (sourceUri.isEmpty()) {
                return Arrays.asList(new NavigationTarget[0]);
            }
            String docUri = ((String)sourceUri.get()).replace(".wf", ".md");
            Map<String, String> args = Collections.singletonMap("jsonOpenerOptions", new JsonOpenerOptions(2, 3, 2, 7).toJson());
            return Arrays.asList(new NavigationTarget(docUri, args));
        }
        return Arrays.asList(new NavigationTarget[0]);
    }
}

