/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.launch;

import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.eclipse.glsp.server.launch.DefaultCLIParser;

public class WorkflowCLIParser
extends DefaultCLIParser {
    public static final String OPTION_WEBSOCKET = "websocket";
    public static final String OPTION_JETTY_LOG_LEVEL = "jettyLogLevel";

    public WorkflowCLIParser(String[] args, String processName) throws ParseException {
        super(args, WorkflowCLIParser.getDefaultOptions(), processName);
    }

    public boolean isWebsocket() {
        return this.hasOption(OPTION_WEBSOCKET);
    }

    public Level parseWebsocketLogLevel() {
        String levelArg = this.parseOption(OPTION_JETTY_LOG_LEVEL, WorkflowOptions.WEBSOCKET_LOG_LEVEL.toString());
        return Level.toLevel((String)levelArg, (Level)WorkflowOptions.WEBSOCKET_LOG_LEVEL);
    }

    public static Options getDefaultOptions() {
        Options options = DefaultCLIParser.getDefaultOptions();
        options.addOption("w", OPTION_WEBSOCKET, false, "Use websocket launcher instead of default launcher.");
        options.addOption("j", OPTION_JETTY_LOG_LEVEL, true, "Set the log level for the Jetty websocket server. [default='INFO']");
        return options;
    }

    public static final class WorkflowOptions {
        public static final Level WEBSOCKET_LOG_LEVEL = Level.INFO;
    }
}

