/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.mgmt.useradmin.internal;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.eclipse.gemini.mgmt.useradmin.internal.OSGiUser;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;

public final class OSGiGroup
extends OSGiUser {
    private String[] members;
    private String[] requiredMembers;

    public OSGiGroup(Group group) {
        super((User)group);
        int n;
        Role[] m = group.getMembers();
        if (m != null) {
            this.members = new String[m.length];
            int i = 0;
            Role[] roleArray = m;
            n = m.length;
            int n2 = 0;
            while (n2 < n) {
                Role role = roleArray[n2];
                this.members[i++] = role.getName();
                ++n2;
            }
        } else {
            this.members = new String[0];
        }
        Role[] rm = group.getRequiredMembers();
        if (rm != null) {
            this.requiredMembers = new String[rm.length];
            int i = 0;
            Role[] roleArray = rm;
            int n3 = rm.length;
            n = 0;
            while (n < n3) {
                Role role = roleArray[n];
                this.requiredMembers[i++] = role.getName();
                ++n;
            }
        } else {
            this.requiredMembers = new String[0];
        }
    }

    public OSGiGroup(CompositeData data) {
        super(data);
        this.members = (String[])data.get("Members");
        this.requiredMembers = (String[])data.get("RequiredMembers");
    }

    @Override
    public CompositeData asCompositeData() throws OpenDataException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Name", this.name);
        items.put("Type", this.type);
        items.put("Members", this.members);
        items.put("RequiredMembers", this.requiredMembers);
        return new CompositeDataSupport(UserAdminMBean.GROUP_TYPE, items);
    }

    public String[] getMembers() {
        return this.members;
    }

    public String[] getRequiredMembers() {
        return this.requiredMembers;
    }
}

