/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExprNoSpecificUnaryExprsCheck
extends CifCheck {
    private final EnumSet<NoSpecificUnaryOp> disalloweds;
    private boolean ignoreAnnotations;

    public ExprNoSpecificUnaryExprsCheck(NoSpecificUnaryOp ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public ExprNoSpecificUnaryExprsCheck(EnumSet<NoSpecificUnaryOp> disalloweds) {
        this.disalloweds = disalloweds;
    }

    public ExprNoSpecificUnaryExprsCheck ignoreAnnotations() {
        return this.ignoreAnnotations(true);
    }

    public ExprNoSpecificUnaryExprsCheck ignoreAnnotations(boolean ignore) {
        this.ignoreAnnotations = ignore;
        return this;
    }

    protected void preprocessUnaryExpression(UnaryExpression unExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)unExpr)) {
            return;
        }
        UnaryOperator op = unExpr.getOperator();
        CifType ctype = CifTypeUtils.normalizeType((CifType)unExpr.getChild().getType());
        switch (op) {
            case INVERSE: {
                if (!this.disalloweds.contains((Object)NoSpecificUnaryOp.INVERSE)) break;
                this.addExprViolationOperator(unExpr, violations);
                break;
            }
            case NEGATE: {
                if (this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE)) {
                    this.addExprViolationOperator(unExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE_INTS)) {
                    if (ctype instanceof IntType) {
                        this.addExprViolationOperand(unExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE_INTS_RANGED) && ctype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ctype))) {
                        this.addExprViolationOperand(unExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE_INTS_RANGELESS) && ctype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ctype))) {
                        this.addExprViolationOperand(unExpr, "a rangeless integer typed", violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificUnaryOp.NEGATE_REALS) || !(ctype instanceof RealType)) break;
                this.addExprViolationOperand(unExpr, "a real typed", violations);
                break;
            }
            case PLUS: {
                if (this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS)) {
                    this.addExprViolationOperator(unExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS_INTS)) {
                    if (ctype instanceof IntType) {
                        this.addExprViolationOperand(unExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS_INTS_RANGED) && ctype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ctype))) {
                        this.addExprViolationOperand(unExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS_INTS_RANGELESS) && ctype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ctype))) {
                        this.addExprViolationOperand(unExpr, "a rangeless integer typed", violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificUnaryOp.PLUS_REALS) || !(ctype instanceof RealType)) break;
                this.addExprViolationOperand(unExpr, "a real typed", violations);
                break;
            }
            case SAMPLE: {
                if (!this.disalloweds.contains((Object)NoSpecificUnaryOp.SAMPLE)) break;
                this.addExprViolationOperator(unExpr, violations);
                break;
            }
            default: {
                throw new RuntimeException("Unknown unary operator: " + String.valueOf(op));
            }
        }
    }

    private void addExprViolationOperator(UnaryExpression unExpr, CifCheckViolations violations) {
        violations.add((PositionObject)unExpr, "Unary operator \"%s\" is used", CifTextUtils.operatorToStr((UnaryOperator)unExpr.getOperator()));
    }

    private void addExprViolationOperand(UnaryExpression unExpr, String operandTxt, CifCheckViolations violations) {
        violations.add((PositionObject)unExpr, "Unary operator \"%s\" is used on %s operand", CifTextUtils.operatorToStr((UnaryOperator)unExpr.getOperator()), operandTxt);
    }

    public static enum NoSpecificUnaryOp {
        INVERSE,
        NEGATE,
        NEGATE_INTS,
        NEGATE_INTS_RANGED,
        NEGATE_INTS_RANGELESS,
        NEGATE_REALS,
        PLUS,
        PLUS_INTS,
        PLUS_INTS_RANGED,
        PLUS_INTS_RANGELESS,
        PLUS_REALS,
        SAMPLE;

    }
}

