/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.eventbased.ControllabilityCheck;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBasedPreChecker;
import org.eclipse.escet.cif.eventbased.apps.options.ReportFileOption;
import org.eclipse.escet.cif.eventbased.automata.EventAtLocation;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class ControllabilityCheckApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        ControllabilityCheckApplication app = new ControllabilityCheckApplication();
        app.run(args, true);
    }

    public ControllabilityCheckApplication() {
    }

    public ControllabilityCheckApplication(AppStreams streams) {
        super(streams);
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(ReportFileOption.class));
        return new OptionCategory("Controllability check", "CIF event-based controllability check options.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(ControllabilityCheckApplication.getGeneralOptionCategory());
        List options = Lists.list();
        String optDesc = "All options for the event-based controllability check tool.";
        return new OptionCategory("Event-based controllability check options", optDesc, subPages, options);
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        String rsltMsg;
        boolean exitCode;
        List<EventAtLocation> disableds;
        block14: {
            ConvertToEventBased cte;
            block13: {
                String absSpecPath;
                Specification spec;
                block12: {
                    OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
                    spec = (Specification)((CifReader)new CifReader().init()).read();
                    absSpecPath = Paths.resolve((String)InputFileOption.getPath());
                    if (!this.isTerminationRequested()) break block12;
                    return 0;
                }
                new ElimComponentDefInst().transform(spec);
                boolean allowPlainEvents = false;
                boolean allowNonDeterminism = false;
                ConvertToEventBasedPreChecker.ExpectedNumberOfAutomata expectedNumberOfAutomata = ConvertToEventBasedPreChecker.ExpectedNumberOfAutomata.AT_LEAST_ONE_PLANT_EXACTLY_ONE_SUPERVISOR;
                EnumSet<SupKind> disallowedAutSupKinds = EnumSet.of(SupKind.NONE, SupKind.REQUIREMENT);
                boolean requireAutHasInitLoc = false;
                boolean requireReqSubsetPlantAlphabet = false;
                boolean requireAutMarkedAndNonMarked = false;
                Termination termination = () -> this.isTerminationRequested();
                ConvertToEventBasedPreChecker checker = new ConvertToEventBasedPreChecker(allowPlainEvents, allowNonDeterminism, expectedNumberOfAutomata, disallowedAutSupKinds, requireAutHasInitLoc, requireReqSubsetPlantAlphabet, requireAutMarkedAndNonMarked, termination);
                checker.reportPreconditionViolations(spec, absSpecPath, this.getAppName());
                OutputProvider.dbg((String)"Converting to internal representation...");
                cte = new ConvertToEventBased();
                cte.convertSpecification(spec);
                if (!this.isTerminationRequested()) break block13;
                return 0;
            }
            OutputProvider.dbg((String)"Applying controllability check...");
            disableds = ControllabilityCheck.controllabilityCheck(cte.automata);
            if (!this.isTerminationRequested()) break block14;
            return 0;
        }
        try {
            String outPath = "_disableds.txt";
            outPath = ReportFileOption.getDerivedPath(".cif", outPath);
            OutputProvider.dbg((String)"Writing result to \"%s\"...", (Object[])new Object[]{outPath});
            String absOutPath = Paths.resolve((String)outPath);
            exitCode = disableds != null && !disableds.get((int)0).evt.isControllable();
            String result = !exitCode ? "HOLDS" : "FAILS";
            rsltMsg = Strings.fmt((String)"Controllability check %s in file \"%s\". See \"%s\" for details.", (Object[])new Object[]{result, InputFileOption.getPath(), outPath});
            FileAppStream stream = new FileAppStream(outPath, absOutPath);
            OutputProvider.dbg((String)rsltMsg);
            stream.printf("Controllability check %s in file \"%s\".\n\n", new Object[]{result, InputFileOption.getPath()});
            if (disableds == null) {
                stream.printf("No disabled events found.\n", new Object[0]);
            } else if (disableds.get((int)0).evt.isControllable()) {
                stream.printf("No disabled uncontrollable event found.\n", new Object[0]);
                stream.printf("\nDisabled controllable events:\n", new Object[0]);
                for (EventAtLocation el : disableds) {
                    stream.printf("  %s\n", new Object[]{el.toString()});
                }
            } else {
                stream.printf("Disabled uncontrollable events:\n", new Object[0]);
                for (EventAtLocation el : disableds) {
                    stream.printf("  %s\n", new Object[]{el.toString()});
                }
            }
            stream.close();
        }
        catch (ApplicationException e) {
            String msg = Strings.fmt((String)"Failed to apply controllability check for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
            throw new ApplicationException(msg, (Throwable)e);
        }
        if (!exitCode) {
            return 0;
        }
        throw new InvalidInputException(rsltMsg);
    }

    public String getAppName() {
        return "CIF controllability check tool";
    }

    public String getAppDescription() {
        return "Verifies whether the supervisor does not disable uncontrollable events of the plant.";
    }
}

