/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;

public abstract class EnumsToBase
extends CifWalker
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating enumerations from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
    }

    protected abstract void preprocessComplexComponent(ComplexComponent var1);

    protected abstract void walkEnumLiteralExpression(EnumLiteralExpression var1);

    protected abstract void walkEnumType(EnumType var1);

    protected static int literalToInt(EnumLiteral lit) {
        EnumDecl enumDecl = (EnumDecl)lit.eContainer();
        EList literals = enumDecl.getLiterals();
        int idx = literals.indexOf(lit);
        Assert.check((idx >= 0 ? 1 : 0) != 0);
        return idx;
    }

    protected static void replaceEnumTypeByIntType(EnumType enumType) {
        IntType intType = CifConstructors.newIntType();
        intType.setLower(Integer.valueOf(0));
        intType.setUpper(Integer.valueOf(enumType.getEnum().getLiterals().size() - 1));
        EMFHelper.updateParentContainment((EObject)enumType, (EObject)intType);
    }
}

