//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.common.svg.selector;

import java.awt.Color;

/**
 * Styles to use for the outline when hovering or clicking an interactive SVG element.
 *
 * @param hoverColor The color to use for the outline when hovering over an interactive SVG element.
 * @param clickColor The color to use for the outline when clicking an interactive SVG element.
 * @param strokeWidth The width to use for the outline when hover over or clicking an interactive SVG element.
 */
public record SvgSelectorOutlineStyle(Color hoverColor, Color clickColor, float strokeWidth) {
    // Empty record.
}
