/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.IOException;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleSheetImpl;
import org.htmlunit.cssparser.dom.DOMExceptionImpl;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.CSSOMParser;
import org.htmlunit.cssparser.util.ParserUtils;
import org.w3c.dom.DOMException;

public class CSSCharsetRuleImpl
extends AbstractCSSRuleImpl {
    private String encoding_;

    public CSSCharsetRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule, String encoding) {
        super(parentStyleSheet, parentRule);
        this.encoding_ = encoding;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            AbstractCSSRuleImpl r = parser.parseRule(cssText);
            if (!(r instanceof CSSCharsetRuleImpl)) {
                throw new DOMExceptionImpl(13, 4);
            }
            this.encoding_ = ((CSSCharsetRuleImpl)r).encoding_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getEncoding() {
        return this.encoding_;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSCharsetRuleImpl)) {
            return false;
        }
        CSSCharsetRuleImpl ccr = (CSSCharsetRuleImpl)obj;
        return super.equals(obj) && ParserUtils.equals(this.getEncoding(), ccr.getEncoding());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = ParserUtils.hashCode(hash, this.encoding_);
        return hash;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        sb.append("@charset \"");
        String enc = this.getEncoding();
        if (null != enc) {
            sb.append(enc);
        }
        sb.append("\";");
        return sb.toString();
    }
}

