/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.targets;

import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.plcgen.generators.PlcVariablePurpose;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.targets.PlcBaseTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.writers.S7Writer;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.java.Assert;

public class SiemensS7Target
extends PlcBaseTarget {
    private static final Pattern BLOCK_KEYWORDS_PATTERN_300_400;
    private static final Pattern ADDRESS_IDENTIFIERS_PATTERN_300_400;
    private static final Map<PlcTargetType, String> OUT_SUFFIX_REPLACEMENTS;
    private static final Map<PlcTargetType, List<PlcElementaryType>> INTEGER_TYPES;
    private static final Map<PlcTargetType, List<PlcElementaryType>> REAL_TYPES;
    private static final Map<PlcTargetType, List<PlcElementaryType>> BIT_STRING_TYPES;
    private static final BitSet SPECIAL_CHARS;
    private static final BitSet NORMAL_CHARS;

    static {
        char[] specials;
        BLOCK_KEYWORDS_PATTERN_300_400 = Pattern.compile("(c|db|fb|fc|ob|sdb|sfc|sfb|t|udt|z)(?<nr>[0-9]+)");
        ADDRESS_IDENTIFIERS_PATTERN_300_400 = Pattern.compile("(((a|d|e|i|m|q)(b|d|w|x)?)|((pa|pe|pi|pq)(b|d|w)))(?<nr>[0-9]+)");
        OUT_SUFFIX_REPLACEMENTS = Map.of(PlcTargetType.S7_300, "_s7_300", PlcTargetType.S7_400, "_s7_400", PlcTargetType.S7_1200, "_s7_1200", PlcTargetType.S7_1500, "_s7_1500");
        INTEGER_TYPES = Map.of(PlcTargetType.S7_300, PlcElementaryType.INTEGER_TYPES_32, PlcTargetType.S7_400, PlcElementaryType.INTEGER_TYPES_32, PlcTargetType.S7_1200, PlcElementaryType.INTEGER_TYPES_32, PlcTargetType.S7_1500, PlcElementaryType.INTEGER_TYPES_64);
        REAL_TYPES = Map.of(PlcTargetType.S7_300, PlcElementaryType.REAL_TYPES_32, PlcTargetType.S7_400, PlcElementaryType.REAL_TYPES_32, PlcTargetType.S7_1200, PlcElementaryType.REAL_TYPES_64, PlcTargetType.S7_1500, PlcElementaryType.REAL_TYPES_64);
        BIT_STRING_TYPES = Map.of(PlcTargetType.S7_300, PlcElementaryType.BIT_STRING_TYPES_32, PlcTargetType.S7_400, PlcElementaryType.BIT_STRING_TYPES_32, PlcTargetType.S7_1200, PlcElementaryType.BIT_STRING_TYPES_32, PlcTargetType.S7_1500, PlcElementaryType.BIT_STRING_TYPES_64);
        SPECIAL_CHARS = new BitSet(128);
        char[] cArray = specials = new char[]{' ', '!', '#', '$', '%', '&', '\'', '(', ')', '*', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '`', '{', '|', '}'};
        int n = specials.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            SPECIAL_CHARS.set(c);
            ++n2;
        }
        NORMAL_CHARS = new BitSet(128);
        NORMAL_CHARS.set(95);
        int i = 0;
        while (i < 26) {
            NORMAL_CHARS.set(65 + i);
            NORMAL_CHARS.set(97 + i);
            ++i;
        }
        i = 0;
        while (i < 10) {
            NORMAL_CHARS.set(48 + i);
            ++i;
        }
    }

    public SiemensS7Target(PlcTargetType targetType) {
        super(targetType, ConvertEnums.CONSTS, "TON");
        Assert.check((boolean)OUT_SUFFIX_REPLACEMENTS.containsKey((Object)targetType));
    }

    @Override
    protected Set<String> getDisallowedNames() {
        Set<String> names = super.getDisallowedNames();
        names.addAll(List.of("and", "any", "array", "begin", "block_db", "block_fb", "block_fc", "block_sdb", "block_sfb", "block_sfc", "bool", "by", "byte", "case", "char", "const", "continue", "counter", "data_block", "date", "date_and_time", "dbo", "dint", "div", "do", "dt", "dword", "else", "elsif", "en", "end_case", "end_const", "end_data_block", "end_for", "end_function", "end_function_block", "end_if", "end_label", "end_organization_block", "end_repeat", "end_struct", "end_type", "end_var", "end_while", "eno", "exit", "false", "for", "function", "function_block", "goto", "if", "int", "label", "mod", "nil", "not", "of", "ok", "or", "organization_block", "pointer", "real", "repeat", "return", "s5time", "string", "struct", "then", "time", "time_of_day", "timer", "to", "tod", "true", "type", "until", "var", "var_in_out", "var_input", "var_output", "var_temp", "void", "while", "word", "xor", "bool_to_byte", "bool_to_dword", "bool_to_word", "byte_to_dword", "byte_to_word", "char_to_string", "dint_to_real", "int_to_dint", "int_to_real", "word_to_dword", "block_db_to_word", "byte_to_bool", "byte_to_char", "char_to_byte", "char_to_int", "date_to_dint", "dint_to_date", "dint_to_dword", "dint_to_int", "dint_to_time", "dint_to_tod", "dword_to_bool", "dword_to_byte", "dword_to_dint", "dword_to_real", "dword_to_word", "int_to_char", "int_to_word", "real_to_dint", "real_to_dword", "real_to_int", "string_to_char", "time_to_dint", "tod_to_dint", "word_to_bool", "word_to_byte", "word_to_int", "word_to_block_db", "round", "trunc", "abs", "sqr", "sqrt", "exp", "expd", "ln", "log", "acos", "asin", "atan", "cos", "sin", "tan", "rol", "ror", "shl", "shr"));
        names.addAll(List.of("iec_timer", "timer", "dummyVar1", "dummyVar2", "dummyVar3", "dummyVar4", "dummyVar5"));
        return names;
    }

    @Override
    public Writer getPlcCodeWriter() {
        return new S7Writer(this);
    }

    @Override
    public PlcTarget.StateVariableStorage getStateVariableStorage() {
        return PlcTarget.StateVariableStorage.STATE_VARS_IN_MAIN;
    }

    @Override
    public boolean supportsArrays() {
        return false;
    }

    @Override
    public boolean supportsConstant(Constant constant) {
        return SiemensS7Target.commonSupportedConstants(constant);
    }

    @Override
    public boolean isAllowedName(String name) {
        int nr2;
        if (!super.isAllowedName(name)) {
            return false;
        }
        Matcher matcher = BLOCK_KEYWORDS_PATTERN_300_400.matcher(name = name.toLowerCase(Locale.US));
        if (matcher.matches()) {
            try {
                nr2 = Integer.valueOf(matcher.group("nr"));
                if (nr2 >= 0 && nr2 <= 65535) {
                    return false;
                }
            }
            catch (NumberFormatException nr2) {
                // empty catch block
            }
        }
        if ((matcher = ADDRESS_IDENTIFIERS_PATTERN_300_400.matcher(name)).matches()) {
            try {
                nr2 = Integer.valueOf(matcher.group("nr"));
                if (nr2 >= 0 && nr2 <= 65535) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public EnumSet<PlcBasicFuncDescription.PlcFuncNotation> getSupportedFuncNotations(PlcFuncOperation funcOper, int numArgs) {
        if (funcOper == PlcFuncOperation.STDLIB_LOG) {
            return PlcBasicFuncDescription.PlcFuncNotation.UNSUPPORTED;
        }
        EnumSet<PlcBasicFuncDescription.PlcFuncNotation> funcSupport = super.getSupportedFuncNotations(funcOper, numArgs);
        EnumSet<PlcFuncOperation> formalFuncs = EnumSet.of(PlcFuncOperation.SEL_OP, PlcFuncOperation.STDLIB_MAX, PlcFuncOperation.STDLIB_MIN);
        if (formalFuncs.contains((Object)funcOper)) {
            funcSupport = EnumSet.copyOf(funcSupport);
            funcSupport.retainAll(PlcBasicFuncDescription.PlcFuncNotation.FORMAL_ONLY);
            return funcSupport;
        }
        if (funcOper == PlcFuncOperation.AND_SHORT_CIRCUIT_OP || funcOper == PlcFuncOperation.OR_SHORT_CIRCUIT_OP) {
            return PlcBasicFuncDescription.PlcFuncNotation.NOT_FORMAL;
        }
        EnumSet<PlcFuncOperation[]> notFormalFuncs = EnumSet.of(PlcFuncOperation.COMPLEMENT_OP, new PlcFuncOperation[]{PlcFuncOperation.STDLIB_ABS, PlcFuncOperation.STDLIB_ACOS, PlcFuncOperation.STDLIB_ASIN, PlcFuncOperation.STDLIB_ATAN, PlcFuncOperation.STDLIB_COS, PlcFuncOperation.STDLIB_EXP, PlcFuncOperation.STDLIB_LN, PlcFuncOperation.STDLIB_LOG, PlcFuncOperation.STDLIB_SIN, PlcFuncOperation.STDLIB_SQRT, PlcFuncOperation.STDLIB_TAN});
        if (notFormalFuncs.contains((Object)funcOper) || numArgs >= 2) {
            funcSupport = EnumSet.copyOf(funcSupport);
            funcSupport.remove((Object)PlcBasicFuncDescription.PlcFuncNotation.FORMAL);
            return funcSupport;
        }
        return funcSupport;
    }

    @Override
    public PlcBasicFuncDescription.PlcFuncTypeExtension getTypeExtension(PlcFuncOperation funcOper) {
        return switch (funcOper) {
            case PlcFuncOperation.SEL_OP -> PlcBasicFuncDescription.PlcFuncTypeExtension.ELEMENTARY_NOT_BOOL;
            default -> PlcBasicFuncDescription.PlcFuncTypeExtension.NEVER;
        };
    }

    @Override
    public List<PlcElementaryType> getSupportedIntegerTypes() {
        return INTEGER_TYPES.get((Object)this.targetType);
    }

    @Override
    public List<PlcElementaryType> getSupportedRealTypes() {
        return REAL_TYPES.get((Object)this.targetType);
    }

    @Override
    public List<PlcElementaryType> getSupportedBitStringTypes() {
        return BIT_STRING_TYPES.get((Object)this.targetType);
    }

    @Override
    public String getUsageVariableText(PlcVariablePurpose purpose, String varName) {
        if (purpose == PlcVariablePurpose.STATE_VAR) {
            return "\"DB\"." + varName;
        }
        if (purpose == PlcVariablePurpose.INPUT_VAR || purpose == PlcVariablePurpose.OUTPUT_VAR) {
            String encodedName = SiemensS7Target.encodeTagName(varName, false);
            Assert.notNull((Object)encodedName);
            return encodedName;
        }
        return super.getUsageVariableText(purpose, varName);
    }

    @Override
    public String getPathSuffixReplacement() {
        return OUT_SUFFIX_REPLACEMENTS.get((Object)this.targetType);
    }

    @Override
    public boolean checkIoVariableName(String name) {
        return SiemensS7Target.encodeTagName(name, false) != null;
    }

    public static String encodeTagName(String name, boolean isLocal) {
        if (name.isEmpty()) {
            return null;
        }
        boolean mustBeQuoted = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c < ' ' || c >= '\u007f') {
                return null;
            }
            if (!NORMAL_CHARS.get(c)) {
                if (SPECIAL_CHARS.get(c)) {
                    mustBeQuoted = true;
                } else {
                    return null;
                }
            }
            ++i;
        }
        char first = name.charAt(0);
        mustBeQuoted |= first >= '0' && first <= '9';
        if (!(mustBeQuoted |= name.endsWith("_") || name.contains("__"))) {
            return name;
        }
        if (isLocal) {
            return "#\"" + name + "\"";
        }
        return "\"" + name + "\"";
    }
}

