/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.expressions;

import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.BinaryOperators;
import org.eclipse.escet.chi.metamodel.chi.BoolLiteral;
import org.eclipse.escet.chi.metamodel.chi.BoolType;
import org.eclipse.escet.chi.metamodel.chi.CallExpression;
import org.eclipse.escet.chi.metamodel.chi.CastExpression;
import org.eclipse.escet.chi.metamodel.chi.ChannelExpression;
import org.eclipse.escet.chi.metamodel.chi.ChannelType;
import org.eclipse.escet.chi.metamodel.chi.ConstantReference;
import org.eclipse.escet.chi.metamodel.chi.DictType;
import org.eclipse.escet.chi.metamodel.chi.DictionaryExpression;
import org.eclipse.escet.chi.metamodel.chi.DictionaryPair;
import org.eclipse.escet.chi.metamodel.chi.DistributionType;
import org.eclipse.escet.chi.metamodel.chi.EnumTypeReference;
import org.eclipse.escet.chi.metamodel.chi.EnumValueReference;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FieldReference;
import org.eclipse.escet.chi.metamodel.chi.FileType;
import org.eclipse.escet.chi.metamodel.chi.FunctionReference;
import org.eclipse.escet.chi.metamodel.chi.FunctionType;
import org.eclipse.escet.chi.metamodel.chi.InstanceType;
import org.eclipse.escet.chi.metamodel.chi.IntNumber;
import org.eclipse.escet.chi.metamodel.chi.IntType;
import org.eclipse.escet.chi.metamodel.chi.ListExpression;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.MatrixExpression;
import org.eclipse.escet.chi.metamodel.chi.MatrixRow;
import org.eclipse.escet.chi.metamodel.chi.MatrixType;
import org.eclipse.escet.chi.metamodel.chi.ModelReference;
import org.eclipse.escet.chi.metamodel.chi.ProcessReference;
import org.eclipse.escet.chi.metamodel.chi.ReadCallExpression;
import org.eclipse.escet.chi.metamodel.chi.RealNumber;
import org.eclipse.escet.chi.metamodel.chi.RealType;
import org.eclipse.escet.chi.metamodel.chi.SetExpression;
import org.eclipse.escet.chi.metamodel.chi.SetType;
import org.eclipse.escet.chi.metamodel.chi.SliceExpression;
import org.eclipse.escet.chi.metamodel.chi.StdLibFunctionReference;
import org.eclipse.escet.chi.metamodel.chi.StringLiteral;
import org.eclipse.escet.chi.metamodel.chi.StringType;
import org.eclipse.escet.chi.metamodel.chi.TimeLiteral;
import org.eclipse.escet.chi.metamodel.chi.TimerType;
import org.eclipse.escet.chi.metamodel.chi.TupleExpression;
import org.eclipse.escet.chi.metamodel.chi.TupleField;
import org.eclipse.escet.chi.metamodel.chi.TupleType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.TypeReference;
import org.eclipse.escet.chi.metamodel.chi.UnaryExpression;
import org.eclipse.escet.chi.metamodel.chi.UnaryOperators;
import org.eclipse.escet.chi.metamodel.chi.VariableReference;
import org.eclipse.escet.chi.metamodel.chi.VoidType;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class BehaviorHelper {
    private BehaviorHelper() {
    }

    public static ExprBehavior getBehavior(Expression expr) {
        CastExpression ce;
        SetExpression se;
        if (expr instanceof ChannelExpression) {
            return ExprBehavior.UNKNOWN;
        }
        if (expr instanceof ReadCallExpression) {
            return ExprBehavior.UNKNOWN;
        }
        if (expr instanceof ModelReference) {
            return ExprBehavior.UNKNOWN;
        }
        if (expr instanceof TimeLiteral) {
            return ExprBehavior.TIME;
        }
        if (expr instanceof BoolLiteral) {
            return ExprBehavior.CONSTANT;
        }
        if (expr instanceof IntNumber) {
            return ExprBehavior.CONSTANT;
        }
        if (expr instanceof StringLiteral) {
            return ExprBehavior.CONSTANT;
        }
        if (expr instanceof RealNumber) {
            return ExprBehavior.CONSTANT;
        }
        if (expr instanceof ProcessReference) {
            return ExprBehavior.CONSTANT;
        }
        if (expr instanceof EnumValueReference) {
            return ExprBehavior.CONSTANT;
        }
        if (expr instanceof FunctionReference) {
            return ExprBehavior.CONSTANT;
        }
        if (expr instanceof ConstantReference) {
            return ExprBehavior.CONSTANT;
        }
        if (expr instanceof StdLibFunctionReference) {
            StdLibFunctionReference sfr = (StdLibFunctionReference)expr;
            switch (sfr.getFunction()) {
                case ABS: 
                case ACOS: 
                case ACOSH: 
                case ASIN: 
                case ASINH: 
                case ATAN: 
                case ATANH: 
                case BERNOULLI: 
                case EMPTY: 
                case ENUMERATE: 
                case ERLANG: 
                case EXP: 
                case EXPONENTIAL: 
                case FLOOR: 
                case GAMMA: 
                case GEOMETRIC: 
                case INSERT: 
                case LN: 
                case LOG: 
                case LOG_NORMAL: 
                case MAX: 
                case MIN: 
                case NORMAL: 
                case POISSON: 
                case POP: 
                case RANDOM: 
                case RANGE: 
                case ROUND: 
                case SIGN: 
                case SIN: 
                case SINH: 
                case SIZE: 
                case SORT: 
                case SQRT: 
                case TAN: 
                case TANH: 
                case TRIANGLE: 
                case UNIFORM: 
                case WEIBULL: 
                case BETA: 
                case BINOMIAL: 
                case CBRT: 
                case CEIL: 
                case CONSTANT: 
                case COS: 
                case COSH: 
                case DELETE: 
                case DICT_KEYS: 
                case DICT_VALUES: {
                    return ExprBehavior.CONSTANT;
                }
                case READY: {
                    return ExprBehavior.TIME;
                }
                case EOF: 
                case EOL: 
                case FINISHED: 
                case NEWLINES: 
                case OPEN: {
                    return ExprBehavior.UNKNOWN;
                }
            }
            Assert.fail((Object)Strings.fmt((String)"Unknown type of library function: %s", (Object[])new Object[]{sfr.getFunction()}));
        }
        if (expr instanceof ListExpression) {
            ListExpression le = (ListExpression)expr;
            ExprBehavior behavior = ExprBehavior.CONSTANT;
            for (Expression e : le.getElements()) {
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(e));
            }
            return behavior;
        }
        if (expr instanceof SetExpression) {
            se = (SetExpression)expr;
            ExprBehavior behavior = ExprBehavior.CONSTANT;
            for (Expression e : se.getElements()) {
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(e));
            }
            return behavior;
        }
        if (expr instanceof MatrixExpression) {
            MatrixExpression me = (MatrixExpression)expr;
            ExprBehavior behavior = ExprBehavior.CONSTANT;
            for (MatrixRow mr : me.getRows()) {
                for (Expression e : mr.getElements()) {
                    behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(e));
                }
            }
            return behavior;
        }
        if (expr instanceof CastExpression) {
            ce = (CastExpression)expr;
            Type tp = CheckType.dropReferences((Type)ce.getType());
            ExprBehavior behavior = tp instanceof TimerType ? ExprBehavior.TIME : ExprBehavior.CONSTANT;
            return BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(ce.getExpression()));
        }
        if (expr instanceof CallExpression) {
            ce = (CallExpression)expr;
            ExprBehavior behavior = BehaviorHelper.getBehavior(ce.getFunction());
            for (Expression e : ce.getArguments()) {
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(e.getType()));
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(e));
            }
            return behavior;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)expr;
            ExprBehavior behavior = ExprBehavior.CONSTANT;
            for (Expression e : te.getFields()) {
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(e));
            }
            return behavior;
        }
        if (expr instanceof DictionaryExpression) {
            DictionaryExpression de = (DictionaryExpression)expr;
            ExprBehavior behavior = ExprBehavior.CONSTANT;
            for (DictionaryPair p : de.getPairs()) {
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(p.getKey()));
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(p.getValue()));
            }
            return behavior;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expr;
            ExprBehavior behavior = be.getOp() == BinaryOperators.PROJECTION ? BehaviorHelper.getBehavior(expr.getType()) : ExprBehavior.CONSTANT;
            behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(be.getLeft()));
            return BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(be.getRight()));
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression ue = (UnaryExpression)expr;
            if (ue.getOp() == UnaryOperators.SAMPLE) {
                return ExprBehavior.UNKNOWN;
            }
            return BehaviorHelper.getBehavior(ue.getChild());
        }
        if (expr instanceof VariableReference) {
            return BehaviorHelper.getBehavior(expr.getType());
        }
        if (expr instanceof FieldReference) {
            return BehaviorHelper.getBehavior(expr.getType());
        }
        if (expr instanceof SliceExpression) {
            se = (SliceExpression)expr;
            ExprBehavior behavior = BehaviorHelper.getBehavior(se.getSource());
            if (se.getStart() != null) {
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(se.getStart()));
            }
            if (se.getEnd() != null) {
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(se.getEnd()));
            }
            if (se.getStep() != null) {
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(se.getStep()));
            }
            return behavior;
        }
        Assert.fail((Object)Strings.fmt((String)"Unknown type of expression: %s", (Object[])new Object[]{expr}));
        return ExprBehavior.CONSTANT;
    }

    private static ExprBehavior getBehavior(Type tp) {
        if (tp instanceof VoidType) {
            return ExprBehavior.CONSTANT;
        }
        if (tp instanceof BoolType) {
            return ExprBehavior.DISCRETE;
        }
        if (tp instanceof IntType) {
            return ExprBehavior.DISCRETE;
        }
        if (tp instanceof StringType) {
            return ExprBehavior.DISCRETE;
        }
        if (tp instanceof RealType) {
            return ExprBehavior.DISCRETE;
        }
        if (tp instanceof ChannelType) {
            return ExprBehavior.DISCRETE;
        }
        if (tp instanceof FunctionType) {
            return ExprBehavior.DISCRETE;
        }
        if (tp instanceof MatrixType) {
            return ExprBehavior.DISCRETE;
        }
        if (tp instanceof EnumTypeReference) {
            return ExprBehavior.DISCRETE;
        }
        if (tp instanceof FileType) {
            return ExprBehavior.UNKNOWN;
        }
        if (tp instanceof DistributionType) {
            return ExprBehavior.UNKNOWN;
        }
        if (tp instanceof InstanceType) {
            return ExprBehavior.UNKNOWN;
        }
        if (tp instanceof TimerType) {
            return ExprBehavior.TIME;
        }
        if (tp instanceof DictType) {
            DictType ttp = (DictType)tp;
            return BehaviorHelper.merge(BehaviorHelper.getBehavior(ttp.getKeyType()), BehaviorHelper.getBehavior(ttp.getValueType()));
        }
        if (tp instanceof SetType) {
            SetType ttp = (SetType)tp;
            return BehaviorHelper.getBehavior(ttp.getElementType());
        }
        if (tp instanceof ListType) {
            ListType ttp = (ListType)tp;
            return BehaviorHelper.getBehavior(ttp.getElementType());
        }
        if (tp instanceof TupleType) {
            TupleType ttp = (TupleType)tp;
            ExprBehavior behavior = ExprBehavior.CONSTANT;
            for (TupleField tf : ttp.getFields()) {
                behavior = BehaviorHelper.merge(behavior, BehaviorHelper.getBehavior(tf.getType()));
            }
            return behavior;
        }
        if (tp instanceof TypeReference) {
            TypeReference ttp = (TypeReference)tp;
            return BehaviorHelper.getBehavior(ttp.getType().getType());
        }
        Assert.fail((Object)Strings.fmt((String)"Unknown type: %s", (Object[])new Object[]{tp}));
        return ExprBehavior.CONSTANT;
    }

    private static ExprBehavior merge(ExprBehavior beh1, ExprBehavior beh2) {
        if (beh1.value > beh2.value) {
            return beh1;
        }
        return beh2;
    }

    public static enum ExprBehavior {
        CONSTANT(0),
        DISCRETE(1),
        TIME(2),
        UNKNOWN(3);

        public final int value;

        private ExprBehavior(int value) {
            this.value = value;
        }
    }
}

