/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.ode;

import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.apache.commons.math3.ode.nonstiff.AdamsBashforthIntegrator;
import org.apache.commons.math3.ode.nonstiff.AdamsMoultonIntegrator;
import org.apache.commons.math3.ode.nonstiff.DormandPrince54Integrator;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import org.apache.commons.math3.ode.nonstiff.GraggBulirschStoerIntegrator;
import org.apache.commons.math3.ode.nonstiff.HighamHall54Integrator;

public enum IntegratorAlgo {
    HIGHAM_HALL("Higham and Hall 5(4) integrator"),
    DORMAND_PRINCE_54("Dormand-Prince 5(4) integrator"),
    DORMAND_PRINCE_853("Dormand-Prince 8(5,3) integrator"),
    GRAGG_BULIRSCH_STOER("Gragg-Bulirsch-Stoer integrator"),
    ADAMS_BASHFORTH("Adams-Bashforth integrator (experimental)"),
    ADAMS_MOULTON("Adams-Moulton integrator (experimental)");

    public final String name;

    private IntegratorAlgo(String name) {
        this.name = name;
    }

    public FirstOrderIntegrator create(int numSteps, double minStep, double maxStep, double atol, double rtol) {
        switch (this) {
            case HIGHAM_HALL: {
                return new HighamHall54Integrator(minStep, maxStep, atol, rtol);
            }
            case DORMAND_PRINCE_54: {
                return new DormandPrince54Integrator(minStep, maxStep, atol, rtol);
            }
            case DORMAND_PRINCE_853: {
                return new DormandPrince853Integrator(minStep, maxStep, atol, rtol);
            }
            case GRAGG_BULIRSCH_STOER: {
                return new GraggBulirschStoerIntegrator(minStep, maxStep, atol, rtol);
            }
            case ADAMS_BASHFORTH: {
                return new AdamsBashforthIntegrator(numSteps, minStep, maxStep, atol, rtol);
            }
            case ADAMS_MOULTON: {
                return new AdamsMoultonIntegrator(numSteps, minStep, maxStep, atol, rtol);
            }
        }
        return null;
    }
}

