/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.IOException;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleSheetImpl;
import org.htmlunit.cssparser.dom.DOMExceptionImpl;
import org.htmlunit.cssparser.dom.MediaListImpl;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.CSSOMParser;
import org.htmlunit.cssparser.util.ParserUtils;
import org.w3c.dom.DOMException;

public class CSSImportRuleImpl
extends AbstractCSSRuleImpl {
    private String href_;
    private MediaListImpl media_;

    public CSSImportRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule, String href, MediaListImpl media) {
        super(parentStyleSheet, parentRule);
        this.href_ = href;
        this.media_ = media;
    }

    @Override
    public String getCssText() {
        MediaListImpl ml;
        StringBuilder sb = new StringBuilder();
        sb.append("@import");
        String href = this.getHref();
        if (null != href) {
            sb.append(" url(\"").append(href).append("\")");
        }
        if (null != (ml = this.getMedia()) && ml.getLength() > 0) {
            sb.append(" ").append(this.getMedia().getMediaText());
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            AbstractCSSRuleImpl r = parser.parseRule(cssText);
            if (!(r instanceof CSSImportRuleImpl)) {
                throw new DOMExceptionImpl(13, 5);
            }
            this.href_ = ((CSSImportRuleImpl)r).href_;
            this.media_ = ((CSSImportRuleImpl)r).media_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getHref() {
        return this.href_;
    }

    public MediaListImpl getMedia() {
        return this.media_;
    }

    public CSSStyleSheetImpl getStyleSheet() {
        return this.getParentStyleSheet();
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSImportRuleImpl)) {
            return false;
        }
        CSSImportRuleImpl cir = (CSSImportRuleImpl)obj;
        return super.equals(obj) && ParserUtils.equals(this.getHref(), cir.getHref()) && ParserUtils.equals(this.getMedia(), cir.getMedia());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = ParserUtils.hashCode(hash, this.href_);
        hash = ParserUtils.hashCode(hash, this.media_);
        return hash;
    }
}

