/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.spec;

import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDVarSet;
import java.util.Arrays;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class CifBddDomain {
    private final BDDFactory factory;
    private final int index;
    private final int[] vars;
    private BDDVarSet varSet;

    CifBddDomain(BDDFactory factory, int index, int[] vars) {
        Assert.notNull((Object)factory);
        Assert.check((index >= 0 ? 1 : 0) != 0);
        Assert.notNull((Object)vars);
        Assert.check((vars.length > 0 ? 1 : 0) != 0);
        Assert.check((boolean)Arrays.stream(vars).allMatch(v -> v >= 0));
        this.factory = factory;
        this.index = index;
        this.vars = vars;
    }

    public BDDFactory getFactory() {
        return this.factory;
    }

    public int getIndex() {
        return this.index;
    }

    public int getVarCount() {
        return this.vars.length;
    }

    public int[] getVarIndices() {
        return this.vars;
    }

    public BDDVarSet makeVarSet() {
        if (this.varSet == null) {
            this.varSet = this.factory.makeSet(this.vars);
        }
        return this.varSet.id();
    }

    public void free() {
        Arrays.fill(this.vars, -1);
        if (this.varSet != null) {
            this.varSet.free();
        }
    }

    public String toString() {
        return Strings.fmt((String)"Domain #%d: vars=%s", (Object[])new Object[]{this.index, Arrays.toString(this.vars)});
    }
}

