/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.function.Supplier;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.TxnOp;

public class Txn {
    public static <T extends Transactional> void execute(T txn, Runnable r) {
        Txn.exec(txn, TxnType.READ_PROMOTE, r);
    }

    public static <T extends Transactional, X> X calculate(T txn, Supplier<X> r) {
        return Txn.calc(txn, TxnType.READ_PROMOTE, r);
    }

    public static <T extends Transactional> void exec(T txn, TxnType txnType, Runnable r) {
        boolean b = txn.isInTransaction();
        if (b) {
            TxnOp.compatibleWithPromote(txnType, txn);
        } else {
            txn.begin(txnType);
        }
        try {
            r.run();
        }
        catch (Throwable th) {
            Txn.onThrowable(th, txn);
            throw th;
        }
        if (!b) {
            if (txn.isInTransaction()) {
                txn.commit();
            }
            txn.end();
        }
    }

    public static <T extends Transactional, X> X calc(T txn, TxnType txnType, Supplier<X> r) {
        X x;
        boolean b = txn.isInTransaction();
        if (b) {
            TxnOp.compatibleWithPromote(txnType, txn);
        } else {
            txn.begin(txnType);
        }
        try {
            x = r.get();
        }
        catch (Throwable th) {
            Txn.onThrowable(th, txn);
            throw th;
        }
        if (!b) {
            if (txn.isInTransaction()) {
                txn.commit();
            }
            txn.end();
        }
        return x;
    }

    public static <T extends Transactional> void executeRead(T txn, Runnable r) {
        Txn.exec(txn, TxnType.READ, r);
    }

    public static <T extends Transactional, X> X calculateRead(T txn, Supplier<X> r) {
        return Txn.calc(txn, TxnType.READ, r);
    }

    public static <T extends Transactional> void executeWrite(T txn, Runnable r) {
        Txn.exec(txn, TxnType.WRITE, r);
    }

    public static <T extends Transactional, X> X calculateWrite(T txn, Supplier<X> r) {
        return Txn.calc(txn, TxnType.WRITE, r);
    }

    private static <T extends Transactional> void onThrowable(Throwable th, T txn) {
        try {
            txn.abort();
            txn.end();
        }
        catch (Throwable th2) {
            th.addSuppressed(th2);
        }
    }
}

