/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.List;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;

public class E_AdjustToTimezone
extends ExprFunctionN {
    public E_AdjustToTimezone(Expr expr1, Expr expr2) {
        super("adjust", expr1, expr2);
    }

    @Override
    public Expr copy(ExprList newArgs) {
        return new E_AdjustToTimezone(super.getArg(0), super.getArg(1));
    }

    @Override
    public NodeValue eval(List<NodeValue> args) {
        if (args.size() != 1 && args.size() != 2) {
            throw new ExprEvalException("ADJUST: Wrong number of arguments: " + args.size() + " : [wanted 1 or 2]");
        }
        NodeValue v1 = args.get(0);
        if (!(v1.isDateTime() || v1.isDate() || v1.isTime())) {
            throw new ExprEvalException("ADJUST: Not an xsd:dateTime, xsd:date or xsd:time : " + v1);
        }
        if (args.size() == 2) {
            NodeValue v2 = args.get(1);
            return XSDFuncOp.adjustToTimezone(v1, v2);
        }
        return XSDFuncOp.adjustToTimezone(v1, null);
    }
}

